<?php

namespace App\Http\Controllers;

use App\Models\EmployeeAttendance;
use App\Models\User;
use Illuminate\Http\Request;

class EmployeeAttendanceWebController extends Controller
{
    public function index(Request $request)
    {
        $query = EmployeeAttendance::with('user')->orderByDesc('date');
        
        if($request->has('user_id')){
            $query->where('user_id', $request->user_id);
        }
        
        $records = $query->paginate(50);
        return view('employee_attendance.index', compact('records'));
    }

    public function create()
    {
        // Filter only employees
        $users = User::where('is_employee', true)->orderBy('name')->get();
        return view('employee_attendance.create', compact('users'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'user_id' => 'required|exists:users,id',
            'date' => 'required|date',
            'check_in_at' => 'nullable',
            'check_out_at' => 'nullable',
            'notes' => 'nullable|string',
            'rating' => 'nullable|integer|min:1|max:5',
            'evaluation_notes' => 'nullable|string'
        ]);

        EmployeeAttendance::create($data);

        return redirect()->route('employee-attendance.index');
    }

    public function show(EmployeeAttendance $employee_attendance)
    {
        return view('employee_attendance.show', ['rec' => $employee_attendance->load('user')]);
    }

    public function edit(EmployeeAttendance $employee_attendance)
    {
        $users = User::where('is_employee', true)->orderBy('name')->get();
        return view('employee_attendance.edit', ['rec' => $employee_attendance, 'users' => $users]);
    }

    public function update(Request $request, EmployeeAttendance $employee_attendance)
    {
        $data = $request->validate([
            'date' => 'nullable|date',
            'check_in_at' => 'nullable',
            'check_out_at' => 'nullable',
            'notes' => 'nullable|string',
            'rating' => 'nullable|integer|min:1|max:5',
            'evaluation_notes' => 'nullable|string'
        ]);

        $employee_attendance->update($data);

        return redirect()->route('employee-attendance.show', $employee_attendance);
    }

    public function destroy(EmployeeAttendance $employee_attendance)
    {
        $employee_attendance->delete();
        return redirect()->route('employee-attendance.index');
    }
}
