<?php
namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Http\Request;

class RoleWebController extends Controller
{
    public function index() { $roles = Role::orderBy('name')->paginate(20); return view('roles.index', compact('roles')); }
    
    public function create() { 
        $permissions = Permission::orderBy('key')->get()->groupBy(function($item){
            return explode('.', $item->key)[0];
        });
        return view('roles.create', compact('permissions')); 
    }

    public function store(Request $request) { 
        $data = $request->validate([
            'name' => 'required|string',
            'key' => 'required|string|unique:roles,key',
            'description' => 'nullable|string',
            'permissions' => 'array',
            'permissions.*' => 'exists:permissions,id'
        ]);
        $role = Role::create($data);
        if(!empty($data['permissions'])) {
            $role->permissions()->sync($data['permissions']);
        }
        return redirect()->route('roles.index'); 
    }

    public function show(Role $role) { 
        $role->load('permissions');
        return view('roles.show', compact('role')); 
    }

    public function edit(Role $role) { 
        $permissions = Permission::orderBy('key')->get()->groupBy(function($item){
            return explode('.', $item->key)[0];
        });
        $rolePermissions = $role->permissions->pluck('id')->toArray();
        return view('roles.edit', compact('role', 'permissions', 'rolePermissions')); 
    }

    public function update(Request $request, Role $role) { 
        $data = $request->validate([
            'name' => 'sometimes|string',
            'key' => 'sometimes|string|unique:roles,key,'.$role->id,
            'description' => 'nullable|string',
            'permissions' => 'array',
            'permissions.*' => 'exists:permissions,id'
        ]);
        $role->update($data);
        if(isset($data['permissions'])) {
            $role->permissions()->sync($data['permissions']);
        }
        return redirect()->route('roles.show',$role); 
    }

    public function destroy(Role $role) { $role->delete(); return redirect()->route('roles.index'); }
}
