<?php
namespace App\Http\Controllers;

use App\Models\Warehouse;
use App\Models\InventoryTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WarehouseWebController extends Controller
{
    public function index() { 
        $warehouses = Warehouse::withCount('transactions')->orderBy('name')->paginate(20);
        
        $stats = [
            'total' => Warehouse::count(),
            'total_transactions' => InventoryTransaction::count(),
            'active_items' => InventoryTransaction::distinct('item_id')->count('item_id')
        ];

        return view('warehouses.index', compact('warehouses', 'stats')); 
    }
    public function create() { return view('warehouses.create'); }
    public function store(Request $request)
    { $data = $request->validate(['name' => 'required|string','location' => 'nullable|string']); Warehouse::create($data); return redirect()->route('warehouses.index'); }
    public function show(Warehouse $warehouse) { 
        // Calculate stock for this warehouse
        $stock = InventoryTransaction::where('warehouse_id', $warehouse->id)
            ->select('item_id', DB::raw("SUM(CASE WHEN type = 'in' THEN quantity WHEN type = 'out' THEN -quantity ELSE 0 END) as current_stock"))
            ->groupBy('item_id')
            ->having('current_stock', '>', 0)
            ->with('item')
            ->get();

        // Recent transactions
        $recent_transactions = $warehouse->transactions()
            ->with(['item']) 
            ->latest()
            ->take(10)
            ->get();

        return view('warehouses.show', compact('warehouse', 'stock', 'recent_transactions')); 
    }
    public function edit(Warehouse $warehouse) { return view('warehouses.edit', compact('warehouse')); }
    public function update(Request $request, Warehouse $warehouse)
    { $data = $request->validate(['name' => 'sometimes|string','location' => 'nullable|string']); $warehouse->update($data); return redirect()->route('warehouses.show',$warehouse); }
    public function destroy(Warehouse $warehouse) { $warehouse->delete(); return redirect()->route('warehouses.index'); }
}
