<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('attachments', function (Blueprint $table) {
            $table->id();
            $table->string('entity_type');
            $table->unsignedBigInteger('entity_id');
            $table->string('path');
            $table->string('mime')->nullable();
            $table->timestamps();
            $table->index(['entity_type','entity_id']);
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('attachments');
    }
};
