<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Dashboard
            ['key' => 'dashboard.view', 'name' => 'عرض لوحة التحكم'],

            // Donors
            ['key' => 'donors.view', 'name' => 'عرض المتبرعين'],
            ['key' => 'donors.create', 'name' => 'إضافة متبرع'],
            ['key' => 'donors.edit', 'name' => 'تعديل متبرع'],
            ['key' => 'donors.delete', 'name' => 'حذف متبرع'],

            // Donations
            ['key' => 'donations.view', 'name' => 'عرض التبرعات'],
            ['key' => 'donations.create', 'name' => 'إضافة تبرع'],
            ['key' => 'donations.edit', 'name' => 'تعديل تبرع'],
            ['key' => 'donations.delete', 'name' => 'حذف تبرع'],

            // Beneficiaries
            ['key' => 'beneficiaries.view', 'name' => 'عرض المستفيدين'],
            ['key' => 'beneficiaries.create', 'name' => 'إضافة مستفيد'],
            ['key' => 'beneficiaries.edit', 'name' => 'تعديل مستفيد'],
            ['key' => 'beneficiaries.delete', 'name' => 'حذف مستفيد'],

            // Logistics - Delegates
            ['key' => 'delegates.view', 'name' => 'عرض المناديب'],
            ['key' => 'delegates.create', 'name' => 'إضافة مندوب'],
            ['key' => 'delegates.edit', 'name' => 'تعديل مندوب'],
            ['key' => 'delegates.delete', 'name' => 'حذف مندوب'],

            // Logistics - Travel Routes
            ['key' => 'travel_routes.view', 'name' => 'عرض خطوط السير'],
            ['key' => 'travel_routes.create', 'name' => 'إضافة خط سير'],
            ['key' => 'travel_routes.edit', 'name' => 'تعديل خط سير'],
            ['key' => 'travel_routes.delete', 'name' => 'حذف خط سير'],

            // Logistics - Trips
            ['key' => 'trips.view', 'name' => 'عرض الرحلات'],
            ['key' => 'trips.create', 'name' => 'إضافة رحلة'],
            ['key' => 'trips.edit', 'name' => 'تعديل رحلة'],
            ['key' => 'trips.delete', 'name' => 'حذف رحلة'],

            // HR - Employees & Users
            ['key' => 'users.view', 'name' => 'عرض الموظفين والمستخدمين'],
            ['key' => 'users.create', 'name' => 'إضافة موظف/مستخدم'],
            ['key' => 'users.edit', 'name' => 'تعديل موظف/مستخدم'],
            ['key' => 'users.delete', 'name' => 'حذف موظف/مستخدم'],

            // HR - Employee Attendance
            ['key' => 'employee_attendance.view', 'name' => 'عرض حضور الموظفين'],
            ['key' => 'employee_attendance.create', 'name' => 'تسجيل حضور موظف'],
            ['key' => 'employee_attendance.edit', 'name' => 'تعديل حضور موظف'],

            // HR - Employee Tasks
            ['key' => 'employee_tasks.view', 'name' => 'عرض مهام الموظفين'],
            ['key' => 'employee_tasks.create', 'name' => 'إضافة مهمة موظف'],
            ['key' => 'employee_tasks.edit', 'name' => 'تعديل مهمة موظف'],
            ['key' => 'employee_tasks.delete', 'name' => 'حذف مهمة موظف'],

            // HR - Volunteers
            ['key' => 'volunteers.view', 'name' => 'عرض المتطوعين'],
            ['key' => 'volunteers.create', 'name' => 'إضافة متطوع'],
            ['key' => 'volunteers.edit', 'name' => 'تعديل متطوع'],
            ['key' => 'volunteers.delete', 'name' => 'حذف متطوع'],

            // HR - Volunteer Attendance
            ['key' => 'volunteer_attendance.view', 'name' => 'عرض حضور المتطوعين'],
            ['key' => 'volunteer_attendance.create', 'name' => 'تسجيل حضور متطوع'],
            ['key' => 'volunteer_attendance.edit', 'name' => 'تعديل حضور متطوع'],

            // HR - Volunteer Tasks
            ['key' => 'volunteer_tasks.view', 'name' => 'عرض مهام المتطوعين'],
            ['key' => 'volunteer_tasks.create', 'name' => 'إضافة مهمة متطوع'],
            ['key' => 'volunteer_tasks.edit', 'name' => 'تعديل مهمة متطوع'],
            ['key' => 'volunteer_tasks.delete', 'name' => 'حذف مهمة متطوع'],

            // HR - Volunteer Hours
            ['key' => 'volunteer_hours.view', 'name' => 'عرض ساعات التطوع'],
            ['key' => 'volunteer_hours.create', 'name' => 'تسجيل ساعات تطوع'],
            ['key' => 'volunteer_hours.edit', 'name' => 'تعديل ساعات تطوع'],

            // HR - Evaluations
            ['key' => 'hr.evaluations', 'name' => 'عرض التقييمات'],
            // ['key' => 'evaluations.create', 'name' => 'إضافة تقييم'], // Route only has index currently
            // ['key' => 'evaluations.edit', 'name' => 'تعديل تقييم'],

            // Accounts - Chart of Accounts
            ['key' => 'accounts.view', 'name' => 'عرض دليل الحسابات'],
            ['key' => 'accounts.create', 'name' => 'إضافة حساب'],
            ['key' => 'accounts.edit', 'name' => 'تعديل حساب'],
            ['key' => 'accounts.delete', 'name' => 'حذف حساب'],

            // Accounts - Journal Entries
            ['key' => 'journal_entries.view', 'name' => 'عرض القيود اليومية'],
            ['key' => 'journal_entries.create', 'name' => 'إضافة قيد'],
            ['key' => 'journal_entries.edit', 'name' => 'تعديل قيد'],
            ['key' => 'journal_entries.delete', 'name' => 'حذف قيد'],

            // Accounts - Expenses
            ['key' => 'expenses.view', 'name' => 'عرض المصروفات'],
            ['key' => 'expenses.create', 'name' => 'إضافة مصروف'],
            ['key' => 'expenses.edit', 'name' => 'تعديل مصروف'],

            // Accounts - Financial Closure
            ['key' => 'financial_closures.view', 'name' => 'عرض الإقفال المالي'],
            ['key' => 'financial_closures.create', 'name' => 'إجراء إقفال مالي'],
            ['key' => 'financial_closures.approve', 'name' => 'اعتماد إقفال مالي'],

            // Warehouse - Warehouses
            ['key' => 'warehouses.view', 'name' => 'عرض المخازن'],
            ['key' => 'warehouses.create', 'name' => 'إضافة مخزن'],
            ['key' => 'warehouses.edit', 'name' => 'تعديل مخزن'],
            ['key' => 'warehouses.delete', 'name' => 'حذف مخزن'],

            // Warehouse - Items
            ['key' => 'items.view', 'name' => 'عرض الأصناف'],
            ['key' => 'items.create', 'name' => 'إضافة صنف'],
            ['key' => 'items.edit', 'name' => 'تعديل صنف'],
            ['key' => 'items.delete', 'name' => 'حذف صنف'],

            // Warehouse - Inventory Transactions
            ['key' => 'inventory_transactions.view', 'name' => 'عرض حركات المخزون'],
            ['key' => 'inventory_transactions.create', 'name' => 'إضافة حركة مخزون'],

            // Project Management
            ['key' => 'projects.view', 'name' => 'عرض المشاريع'],
            ['key' => 'projects.create', 'name' => 'إضافة مشروع'],
            ['key' => 'projects.edit', 'name' => 'تعديل مشروع'],
            ['key' => 'projects.delete', 'name' => 'حذف مشروع'],

            // Campaign Management
            ['key' => 'campaigns.view', 'name' => 'عرض الحملات'],
            ['key' => 'campaigns.create', 'name' => 'إضافة حملة'],
            ['key' => 'campaigns.edit', 'name' => 'تعديل حملة'],
            ['key' => 'campaigns.delete', 'name' => 'حذف حملة'],

            // HR - Payroll
            ['key' => 'payroll.view', 'name' => 'عرض الرواتب'],
            ['key' => 'payroll.create', 'name' => 'إضافة راتب'],
            ['key' => 'payroll.edit', 'name' => 'تعديل راتب'],
            ['key' => 'payroll.delete', 'name' => 'حذف راتب'],

            // Guest House Management
            ['key' => 'guest_houses.view', 'name' => 'عرض دور الضيافة'],
            ['key' => 'guest_houses.create', 'name' => 'إضافة دار ضيافة'],
            ['key' => 'guest_houses.edit', 'name' => 'تعديل دار ضيافة'],
            ['key' => 'guest_houses.delete', 'name' => 'حذف دار ضيافة'],

            // Workspace Ensan
            ['key' => 'workspaces.view', 'name' => 'عرض مساحات العمل'],
            ['key' => 'workspaces.create', 'name' => 'إضافة مساحة عمل'],
            ['key' => 'workspaces.edit', 'name' => 'تعديل مساحة عمل'],
            ['key' => 'workspaces.delete', 'name' => 'حذف مساحة عمل'],

            // Notifications
            ['key' => 'notifications.view', 'name' => 'عرض الإشعارات'],
            ['key' => 'notifications.create', 'name' => 'إرسال إشعار'],

            // Complaints
            ['key' => 'complaints.view', 'name' => 'عرض الشكاوى'],
            ['key' => 'complaints.create', 'name' => 'إضافة شكوى'],
            ['key' => 'complaints.edit', 'name' => 'تعديل شكوى'],
            ['key' => 'complaints.delete', 'name' => 'حذف شكوى'],

            // Logs
            ['key' => 'logs.view', 'name' => 'عرض السجلات'],

            // Roles (System)
            ['key' => 'roles.view', 'name' => 'عرض الأدوار'],
            ['key' => 'roles.create', 'name' => 'إضافة دور'],
            ['key' => 'roles.edit', 'name' => 'تعديل دور'],
            ['key' => 'roles.delete', 'name' => 'حذف دور'],
        ];

        foreach ($permissions as $p) {
            Permission::firstOrCreate(
                ['key' => $p['key']],
                ['name' => $p['name']]
            );
        }
    }
}
