@extends('layouts.app')
@section('content')
<div class="card p-4">
  <h5 class="mb-3">إضافة مستفيد</h5>
  <form method="POST" action="{{ route('beneficiaries.store') }}">
    @csrf
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">الاسم</label><input name="full_name" class="form-control" required pattern="^[\u0621-\u064A\s]+$" title="اكتب الاسم بالعربية فقط"></div>
      <div class="col-md-6"><label class="form-label">رقم قومي</label><input name="national_id" class="form-control" required pattern="^[23]\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])\d{7}$" title="الرقم القومي 14 رقم بصيغة صحيحة"></div>
      <div class="col-md-6"><label class="form-label">الهاتف</label><input name="phone" class="form-control" required pattern="^(01[0125]\d{8}|\+?201[0125]\d{8})$" title="ابدأ بـ 010 أو 011 أو 012 أو 015"></div>
      <div class="col-md-6"><label class="form-label">العنوان</label><input name="address" class="form-control" required></div>
      <div class="col-md-6"><label class="form-label">نوع المساعدة</label>
        <select name="assistance_type" class="form-select" required>
          <option value="financial">مالية</option><option value="in_kind">عينية</option><option value="service">خدمية</option>
        </select>
      </div>
      <div class="col-md-4"><label class="form-label">المشروع</label>
        <select name="project_id" class="form-select"><option value="">—</option>@foreach($projects as $p)<option value="{{ $p->id }}">{{ $p->name }}</option>@endforeach</select>
      </div>
      <div class="col-md-4"><label class="form-label">دار الضيافه</label>
        <select name="guest_house_id" class="form-select">
          <option value="">—</option>
          @foreach($guestHouses as $gh)
            <option value="{{ $gh->id }}">{{ $gh->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-4"><label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select"><option value="">—</option>@foreach($campaigns as $c)<option value="{{ $c->id }}">{{ $c->name }} ({{ $c->season_year }})</option>@endforeach</select>
      </div>
      <div class="col-12"><label class="form-label">ملاحظات داخلية</label><textarea name="notes" class="form-control" rows="2"></textarea></div>
    </div>
    <div class="mt-3"><button class="btn btn-primary">حفظ</button><a href="{{ route('beneficiaries.index') }}" class="btn btn-light">رجوع</a></div>
  </form>
</div>
@endsection
