@extends('layouts.app')
@section('content')
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">المستفيدون</h4>
    <a href="{{ route('beneficiaries.create') }}" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة مستفيد</a>
  </div>
  <div class="row g-3 mb-3">
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">إجمالي</div>
        <div class="fs-5 fw-bold">{{ $stats['total'] }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">جديد</div>
        <div class="fs-5 fw-bold">{{ $stats['new'] }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">تحت المراجعة</div>
        <div class="fs-5 fw-bold">{{ $stats['under_review'] }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">مقبول</div>
        <div class="fs-5 fw-bold">{{ $stats['accepted'] }}</div>
      </div>
    </div>
  </div>
  <form method="GET" class="card p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-4">
        <label class="form-label">بحث بالاسم/الهاتف/الرقم القومي</label>
        <input name="q" value="{{ $q ?? '' }}" class="form-control" placeholder="ابحث...">
      </div>
      <div class="col-md-3">
        <label class="form-label">الحالة</label>
        <select name="status" class="form-select">
          <option value="">الكل</option>
          <option value="new" @selected(($status ?? '') === 'new')>جديد</option>
          <option value="under_review" @selected(($status ?? '') === 'under_review')>تحت المراجعة</option>
          <option value="accepted" @selected(($status ?? '') === 'accepted')>مقبول</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">نوع المساعدة</label>
        <select name="assistance_type" class="form-select">
          <option value="">الكل</option>
          <option value="financial" @selected(($atype ?? '') === 'financial')>مالية</option>
          <option value="in_kind" @selected(($atype ?? '') === 'in_kind')>عينية</option>
          <option value="service" @selected(($atype ?? '') === 'service')>خدمية</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select">
          <option value="">الكل</option>
          @foreach($projects as $p)
            <option value="{{ $p->id }}" @selected(($projectId ?? '') == $p->id)>{{ $p->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select">
          <option value="">الكل</option>
          @foreach($campaigns as $c)
            <option value="{{ $c->id }}" @selected(($campaignId ?? '') == $c->id)>{{ $c->name }} ({{ $c->season_year }})
            </option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">من تاريخ</label>
        <input type="date" name="date_from" value="{{ $dateFrom ?? '' }}" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">إلى تاريخ</label>
        <input type="date" name="date_to" value="{{ $dateTo ?? '' }}" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">العنوان يحتوي</label>
        <input name="address_like" value="{{ $addressLike ?? '' }}" class="form-control" placeholder="مدينة/حي...">
      </div>
      <div class="col-md-3">
        <label class="form-label">فقط من لديهم هاتف</label>
        <select name="has_phone" class="form-select">
          <option value="">الكل</option>
          <option value="1" @selected(($hasPhone ?? '') === '1')>نعم</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">فقط من لديهم مرفقات</label>
        <select name="has_attachments" class="form-select">
          <option value="">الكل</option>
          <option value="1" @selected(($hasAttachments ?? '') === '1')>نعم</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">عدد الصفوف</label>
        <select name="per_page" class="form-select">
          <option value="20" @selected(($perPage ?? 20) == 20)>20</option>
          <option value="50" @selected(($perPage ?? 20) == 50)>50</option>
          <option value="100" @selected(($perPage ?? 20) == 100)>100</option>
        </select>
      </div>
      <div class="col-md-2 d-flex gap-2">
        <button class="btn btn-primary flex-fill">تصفية</button>
        <a class="btn btn-outline-secondary" href="{{ route('beneficiaries.export', request()->query()) }}">تصدير CSV</a>
      </div>
    </div>
  </form>
  <div class="table-responsive">
    @php
      $curSort = $sort ?? request('sort');
      $curDir = $dir ?? request('dir');
      $toggle = ($curDir === 'asc' ? 'desc' : 'asc');
    @endphp
    <form method="POST" action="{{ route('beneficiaries.bulk') }}" id="bulkForm">@csrf
      <table class="table table-striped">
        <thead>
          <tr>
            <th><input type="checkbox"
                onclick="document.querySelectorAll('.row-check').forEach(cb=>cb.checked=this.checked)"></th>
            <th><a
                href="{{ route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'id', 'dir' => $toggle])) }}">#</a>
            </th>
            <th><a
                href="{{ route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'full_name', 'dir' => $toggle])) }}">الاسم</a>
            </th>
            <th>الرقم القومي</th>
            <th>الهاتف</th>
            <th><a
                href="{{ route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'status', 'dir' => $toggle])) }}">الحالة</a>
            </th>
            <th><a
                href="{{ route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'assistance_type', 'dir' => $toggle])) }}">المساعدة</a>
            </th>
            <th>المشروع</th>
            <th>الحملة</th>
            <th><a
                href="{{ route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'created_at', 'dir' => $toggle])) }}">تاريخ
                الإنشاء</a></th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach($beneficiaries as $b)
            <tr>
              <td><input type="checkbox" class="row-check" name="ids[]" value="{{ $b->id }}"></td>
              <td>{{ $b->id }}</td>
              <td>{{ $b->full_name }}</td>
              <td>{{ $b->national_id ?? '—' }}</td>
              <td>{{ $b->phone ?? '—' }}</td>
              <td>
                @php
                  $s = $b->status;
                  $cls = $s === 'accepted' ? 'success' : ($s === 'under_review' ? 'warning' : 'secondary');
                  $s_ar = $s === 'new' ? 'جديد' : ($s === 'under_review' ? 'تحت المراجعة' : ($s === 'accepted' ? 'مقبول' : $s));
                @endphp
                <span class="badge bg-{{ $cls }}">{{ $s_ar }}</span>
                @php $isDup = ((in_array($b->phone, $dupPhones ?? []) && $b->phone) || (in_array($b->national_id, $dupNids ?? []) && $b->national_id)); @endphp
                @if($isDup)
                  <span class="badge bg-danger">مكرر</span>
                @endif
              </td>
              <td>
                @php
                  $t = $b->assistance_type;
                  $tcls = $t === 'financial' ? 'primary' : ($t === 'in_kind' ? 'info' : 'dark');
                  $t_ar = $t === 'financial' ? 'مالية' : ($t === 'in_kind' ? 'عينية' : ($t === 'service' ? 'خدمية' : $t));
                @endphp
                <span class="badge bg-{{ $tcls }}">{{ $t_ar }}</span>
              </td>
              <td>{{ $b->project?->name ?? '—' }}</td>
              <td>{{ $b->campaign?->name ? ($b->campaign->name . ' (' . $b->campaign->season_year . ')') : '—' }}</td>
              <td>{{ optional($b->created_at)->format('Y-m-d') ?? '—' }}</td>
              <td class="text-end">
                <div class="dropdown">
                  <button class="btn btn-sm btn-light border dropdown-toggle" type="button" data-bs-toggle="dropdown"
                    aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i> خيارات
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="{{ route('beneficiaries.show', $b) }}"><i
                          class="bi bi-eye me-2 text-primary"></i>عرض</a></li>
                    <li><a class="dropdown-item" href="{{ route('beneficiaries.edit', $b) }}"><i
                          class="bi bi-pencil me-2 text-secondary"></i>تعديل</a></li>

                    @php
                      $attCount = $b->attachments_count ?? 0;
                      $next = $b->status === 'new' ? 'under_review' : ($b->status === 'under_review' ? 'accepted' : null);
                      $next_ar = $next === 'under_review' ? 'تحت المراجعة' : ($next === 'accepted' ? 'مقبول' : $next);
                    @endphp

                    @if($next)
                      <li>
                        <form action="{{ route('beneficiaries.update', $b) }}" method="POST">
                          @csrf @method('PUT')
                          <input type="hidden" name="status" value="{{ $next }}">
                          <button class="dropdown-item"><i class="bi bi-arrow-repeat me-2 text-success"></i>نقل إلى
                            {{ $next_ar }}</button>
                        </form>
                      </li>
                    @endif

                    <li><a class="dropdown-item"
                        href="{{ route('tasks.create', ['assigned_to' => request()->user()?->id, 'subject_beneficiary_id' => $b->id]) }}"><i
                          class="bi bi-check-square me-2"></i>مهمة مرتبطة</a></li>

                    <li>
                      <hr class="dropdown-divider">
                    </li>

                    <li>
                      <form action="{{ route('beneficiaries.destroy', $b) }}" method="POST"
                        onsubmit="return confirm('حذف المستفيد؟');">
                        @csrf @method('DELETE')
                        <button class="dropdown-item text-danger"><i class="bi bi-trash me-2"></i>حذف</button>
                      </form>
                    </li>
                  </ul>
                </div>
                @if($attCount > 0)
                  <div class="mt-1"><span class="badge bg-info bg-opacity-10 text-info" style="font-size:0.7rem"><i
                        class="bi bi-paperclip"></i> {{ $attCount }}</span></div>
                @endif
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="d-flex gap-2 align-items-center mt-2">
        <select name="bulk_action" class="form-select" style="width:auto">
          <option value="">إجراء جماعي...</option>
          <option value="status_under_review">نقل إلى تحت المراجعة</option>
          <option value="status_accepted">نقل إلى مقبول</option>
        </select>
        <button class="btn btn-success" onclick="document.getElementById('bulkForm').submit()">تنفيذ</button>
      </div>
    </form>
  </div>
  <div class="mt-3">{{ $beneficiaries->links() }}</div>
  <div class="row g-3 mt-3">
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">آخر 7 أيام</div>
        <div class="h4 mb-0">{{ $last7 }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">مالية</div>
        <div class="h4 mb-0">{{ $assistDist['financial'] ?? 0 }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">عينية</div>
        <div class="h4 mb-0">{{ $assistDist['in_kind'] ?? 0 }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">خدمية</div>
        <div class="h4 mb-0">{{ $assistDist['service'] ?? 0 }}</div>
      </div>
    </div>
  </div>
@endsection