@extends('layouts.app')
@section('content')
  <style>
    .kpi-card,
    .chart-wrap,
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      transition: transform 0.2s;
    }

    .kpi-card:hover {
      transform: translateY(-2px);
    }

    .bar-grid {
      display: flex;
      align-items: flex-end;
      gap: 8px;
      height: 180px;
      padding: 16px;
      background: #f8f9fa;
      /* var(--bg) */
      border-radius: 12px;
      border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .bar {
      width: 100%;
      min-width: 8px;
      border-radius: 4px 4px 0 0;
      transition: height 0.3s ease;
    }

    .bar.cash {
      background: var(--primary);
      opacity: 0.8;
    }

    .bar.kind {
      background: var(--accent);
      opacity: 0.8;
    }

    .bar:hover {
      opacity: 1;
    }

    .bar-labels {
      display: flex;
      gap: 8px;
      justify-content: space-between;
      font-size: 0.8rem;
    }

    .chip {
      display: inline-block;
      padding: 0.25rem 0.75rem;
      border-radius: 50px;
      background: rgba(44, 168, 122, 0.1);
      color: var(--primary-dark);
      font-weight: 600;
      font-size: 0.85rem;
    }

    .list-simple li {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 0.75rem 0;
      border-bottom: 1px solid #f0f0f0;
    }

    .list-simple li:last-child {
      border-bottom: none;
    }

    .text-primary-custom {
      color: var(--primary);
    }

    .theme-dark .bar-grid {
      background: rgba(255, 255, 255, 0.05);
      border-color: rgba(255, 255, 255, 0.05);
    }

    .theme-dark .list-simple li {
      border-color: rgba(255, 255, 255, 0.05);
    }

    .theme-dark .chip {
      color: var(--accent);
      background: rgba(44, 168, 122, 0.15);
    }
  </style>

  @if($isFinance ?? false)
    {{-- Finance Dashboard --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم المحاسبة</h2>
       <div class="d-flex gap-3 align-items-center">
           <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-primary rounded-pill px-3">
               <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
           </a>
          <div class="text-muted small">{{ date('Y-m-d') }}</div>
      </div>
    </div>

    {{-- Row 0: My Stats (Employee) --}}
    <div class="row g-3 mb-4">
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
              <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الراتب ({{ $financeStats['salary_month'] }})</div>
                  <i class="bi bi-wallet2 text-success opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ number_format($financeStats['salary']) }}</div>
              <div class="small text-muted mt-1">آخر راتب مسجل</div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">حضوري هذا الشهر</div>
                  <i class="bi bi-calendar-check text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $financeStats['attendance'] }} <span class="fs-6 fw-normal text-muted">يوم</span></div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">رصيد الإجازات</div>
                  <i class="bi bi-sun text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $financeStats['vacations_balance'] }} <span class="fs-6 fw-normal text-muted">يوم</span></div>
              <div class="progress mt-2" style="height: 4px;">
                  <div class="progress-bar bg-warning" style="width: 80%"></div>
              </div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">مهام معلقة</div>
                  <i class="bi bi-list-task text-danger opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $financeStats['tasks_pending'] }}</div>
              <a href="{{ route('employee-tasks.index') }}" class="stretched-link"></a>
          </div>
      </div>
    </div>

    {{-- Row 1: Counts --}}
    <div class="row g-3 mb-3">
      <div class="col-md-4"><a href="{{ route('warehouses.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المخازن</div>
          <div class="display-6 fw-bold text-dark">{{ $warehousesCount }}</div>
      </a></div>
      <div class="col-md-4"><a href="{{ route('donors.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتبرعون</div>
          <div class="display-6 fw-bold text-dark">{{ $donorsCount }}</div>
      </a></div>
      <div class="col-md-4"><a href="{{ route('beneficiaries.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المستفيدون</div>
          <div class="display-6 fw-bold text-dark">{{ $beneficiariesCount }}</div>
      </a></div>
    </div>

    {{-- Row 2: Financials Month --}}
    <div class="row g-3 mb-3">
      <div class="col-md-3"><a href="{{ route('donations.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات نقدية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-primary-custom">{{ number_format($cashMonth, 2) }}</div>
      </a></div>
      <div class="col-md-3"><a href="{{ route('donations.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات عينية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-success">{{ number_format($inKindMonth, 2) }}</div>
      </a></div>
      <div class="col-md-3"><a href="{{ route('expenses.index') }}" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">مصروفات (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-danger">{{ number_format($expensesMonth, 2) }}</div>
      </a></div>
      <div class="col-md-3"><div class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">صافي التدفق (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-dark" style="direction: ltr;">{{ number_format($netFlowMonth, 2) }}</div>
      </div></div>
    </div>

    {{-- Row 3: Charts --}}
    {{-- Using existing variables for charts --}}
    @php $maxVal = max(array_merge($cashSeries, $inKindSeries));
    $maxVal = $maxVal > 0 ? $maxVal : 1; @endphp
    <div class="row g-3 mb-3">
      <div class="col-md-8">
        <div class="card chart-wrap p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">توزيع التبرعات (آخر 12 شهرًا)</h5>
            <span class="chip">نقدي مقابل عيني</span>
          </div>
          <div class="bar-grid">
            @for($i = 0; $i < count($months); $i++)
              @php 
                                      $cm = $cashSeries[$i];
                $km = $inKindSeries[$i];
                $ch = max(round(($cm / $maxVal) * 180), 4);
                $kh = max(round(($km / $maxVal) * 180), 4); 
              @endphp
              <div style="display:flex;gap:4px;align-items:flex-end;flex:1;justify-content:center;">
                <div class="bar cash" style="height:{{ $ch }}px" title="{{ $months[$i] }} (نقدي): {{ number_format($cm, 2) }}" data-bs-toggle="tooltip"></div>
                <div class="bar kind" style="height:{{ $kh }}px" title="{{ $months[$i] }} (عيني): {{ number_format($km, 2) }}" data-bs-toggle="tooltip"></div>
              </div>
            @endfor
          </div>
          <div class="bar-labels mt-2 small text-muted text-center">
            @foreach($months as $m)<span style="flex:1">{{ $m }}</span>@endforeach
          </div>
        </div>
      </div>
      <div class="col-md-4">
          {{-- Net Flow Chart - Simple custom visual since we don't have a JS chart lib configured yet --}}
          <div class="card chart-wrap p-3 h-100">
              <h5 class="mb-3 fw-bold">صافي التدفق (آخر 12 شهرًا)</h5>
              <div style="display: flex; flex-direction: column; justify-content: space-between; height: 100%;">
                  <div style="flex: 1; display: flex; align-items: flex-end; gap: 6px;">
                      @php 
                                                                    $maxExp = max($expenseSeries) > 0 ? max($expenseSeries) : 1;
                        $maxInc = $maxVal > 0 ? $maxVal : 1; // From donation max
                        $globalMax = max($maxExp, $maxInc);
                      @endphp
                      @for($i = 0; $i < count($months); $i++)
                        @php 
                                                                        $inc = $cashSeries[$i] + $inKindSeries[$i]; // Total Income
                          $exp = $expenseSeries[$i] ?? 0;
                          $net = $inc - $exp;
                          $h = max(round(($inc / $globalMax) * 80), 2); // Income height
                          $eh = max(round(($exp / $globalMax) * 80), 2); // Expense height
                        @endphp
                         <div style="flex:1; display:flex; flex-direction:column; justify-content:flex-end; align-items:center;">
                             {{-- Stackedish or Side by side simple bars --}}
                             <div style="width:6px; height:{{ $h }}px; background:var(--primary); opacity:0.7; border-radius:2px;" title="Income: {{ number_format($inc) }}" data-bs-toggle="tooltip"></div>
                             <div style="width:6px; height:{{ $eh }}px; background:#dc3545; opacity:0.7; border-radius:2px; margin-top:-{{ min($h, $eh) }}px; margin-left:8px;" title="Expense: {{ number_format($exp) }}" data-bs-toggle="tooltip"></div>
                         </div>
                      @endfor
                  </div>
                  <div class="text-center small text-muted mt-2">
                       <span class="text-primary fs-7">● دخل</span> <span class="text-danger fs-7">● مصروف</span>
                  </div>
              </div>
          </div>
      </div>
    </div>

    {{-- Row 4: Details & Widgets --}}
    <div class="row g-3 mt-1">
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary">{{ $cashMonthPct }}%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success">{{ $inKindMonthPct }}%</div>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
              <ul class="list-unstyled list-simple mb-0">
              @foreach($topDonors as $td)
                <li>
                    <span>{{ $td['name'] }}</span>
                    <span class="chip">{{ number_format($td['total'], 2) }}</span>
                </li>
              @endforeach
              </ul>
          </div>
      </div>

      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل 5 أصناف مخزون</h5>
              <ul class="list-unstyled list-simple mb-0">
              @forelse($inventoryLevels as $inv)
                <li>
                <span>{{ $inv->item->name ?? '—' }}</span>
                <span class="chip">{{ $inv->current_stock }}</span>
                </li>
              @empty
                <li class="text-center text-muted">المخزون فارغ</li>
              @endforelse
              </ul>
          </div>
      </div>
    </div>

    <div class="row g-3 mt-3">
         <div class="col-md-6">
              <div class="card kpi-card p-3 h-100">
                  <div class="d-flex justify-content-between align-items-center mb-3">
                      <h5 class="mb-0 fw-bold">آخر التبرعات</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('donations.index') }}">عرض الكل</a>
                  </div>
                  <ul class="list-unstyled list-simple mb-0">
                  @foreach($latestDonations as $d)
                    <li>
                    <div>
                        <div class="fw-bold">{{ $d->donor?->name ?? '—' }}</div>
                        <div class="small text-muted">{{ $d->type === 'cash' ? 'نقدي' : 'عيني' }}</div>
                    </div>
                    <span class="chip">{{ number_format($d->amount ?? $d->estimated_value, 2) }}</span>
                    </li>
                  @endforeach
                  </ul>
              </div>
         </div>
         <div class="col-md-6">
             {{-- Expense Distribution --}}
            <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">توزيع المصروفات (هذا الشهر)</h5>
              @if(count($expenseByCat) > 0)
                <ul class="list-unstyled list-simple mb-0">
                  @foreach($expenseByCat as $ec)
                    <li>
                      <span>{{ $ec->category ?? 'أخرى' }}</span>
                      <span class="fw-bold text-dark">{{ number_format($ec->total, 2) }}</span>
                    </li>
                  @endforeach
                </ul>
              @else
                <div class="text-center py-4 text-muted">لا توجد مصروفات هذا الشهر</div>
              @endif
            </div>
         </div>
    </div>

  @elseif($isHr ?? false)
    {{-- HR Dashboard --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم الموارد البشرية</h2>
      <div class="d-flex gap-3 align-items-center">
          <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-primary rounded-pill px-3">
              <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
          </a>
          <div class="text-muted small">{{ date('Y-m-d') }}</div>
      </div>
    </div>

    {{-- Row 0: My Stats (Employee) --}}
    <div class="row g-3 mb-4">
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
              <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الراتب ({{ $hrStats['salary_month'] }})</div>
                  <i class="bi bi-wallet2 text-success opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ number_format($hrStats['salary']) }}</div>
              <div class="small text-muted mt-1">آخر راتب مسجل</div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">حضوري هذا الشهر</div>
                  <i class="bi bi-calendar-check text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $hrStats['attendance'] }} <span class="fs-6 fw-normal text-muted">يوم</span></div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">رصيد الإجازات</div>
                  <i class="bi bi-sun text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $hrStats['vacations_balance'] }} <span class="fs-6 fw-normal text-muted">يوم</span></div>
              <div class="progress mt-2" style="height: 4px;">
                  <div class="progress-bar bg-warning" style="width: 80%"></div>
              </div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">مهام معلقة</div>
                  <i class="bi bi-list-task text-danger opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ $hrStats['tasks_pending'] }}</div>
              <a href="{{ route('employee-tasks.index') }}" class="stretched-link"></a>
          </div>
      </div>
    </div>

    {{-- Row 1: Notifications --}}
    <div class="row g-3 mb-3">
      <div class="col-md-12">
        <div class="card p-3 shadow-sm border-0">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          @forelse($notifications as $n)
            <div class="alert alert-{{ $n['type'] }} py-2 mb-2 small shadow-sm border-0">{{ $n['text'] }}</div>
          @empty
            <div class="text-muted text-center py-2">لا توجد تنبيهات</div>
          @endforelse
        </div>
      </div>
    </div>

    {{-- Row 2: Top Donors, Distribution & Evaluations --}}
    <div class="row g-3 mb-3">
      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
              <ul class="list-unstyled list-simple mb-0">
              @foreach($topDonors as $td)
                <li>
                    <span>{{ $td['name'] }}</span>
                    <span class="chip">{{ number_format($td['total'], 2) }}</span>
                </li>
              @endforeach
              </ul>
          </div>
      </div>
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary">{{ $cashMonthPct }}%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success">{{ $inKindMonthPct }}%</div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-4">
          <a href="{{ route('hr.evaluations') }}" class="card kpi-card p-3 h-100 text-decoration-none">
              <div class="d-flex justify-content-between align-items-center mb-3">
                  <h5 class="mb-0 fw-bold text-dark">التقييمات والمتابعة</h5>
                  <i class="bi bi-arrow-left text-muted"></i>
              </div>
              <div class="d-flex align-items-center justify-content-center flex-column py-2">
                   <div class="icon-circle bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                      <i class="bi bi-star fs-3"></i>
                  </div>
                  <div class="text-muted small text-center">عرض إحصائيات الأداء، الرواتب، والحضور</div>
              </div>
          </a>
      </div>
    </div>

    {{-- Row 3: Tasks & Attendance --}}
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المهام</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="{{ route('tasks.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestTasks as $t)
              <li>
                <div>
                  <div class="fw-bold">{{ $t->title ?? ('مهمة #' . $t->id) }}</div>
                  @if($t->due_date)
                    <div class="small {{ $t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted' }}">
                      <i class="bi bi-calendar-event me-1"></i>{{ $t->due_date->format('Y-m-d') }}
                    </div>
                  @endif
                </div>
                <span class="badge bg-secondary-subtle text-body border">{{ $t->status ?? '—' }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">حضور اليوم</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="{{ route('volunteer-attendance.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestAttendance as $a)
              <li><span>{{ $a->user?->name ?? '—' }}</span><span
                  class="small text-muted">{{ $a->date?->format('H:i') ?? '—' }}</span></li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    {{-- Row 4: Volunteer Honor Board --}}
    <div class="row g-3 mb-3">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                @foreach(collect($evaluations)->sortByDesc('score')->take(5) as $ev)
                  <tr>
                    <td class="fw-bold">{{ $ev['name'] }}</td>
                    <td class="text-center">{{ number_format($ev['hours'], 1) }}</td>
                    <td class="text-center">{{ $ev['attendance'] }}</td>
                    <td class="text-center">{{ $ev['tasks'] }}</td>
                    <td class="text-center fw-bold text-primary">{{ $ev['score'] }}</td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ min($ev['score'], 100) }}%">
                        </div>
                      </div>
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    {{-- Row 5: Campaigns/Projects --}}
    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">الحملات النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('campaigns.index') }}">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">الحملة</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                @forelse($activeCampaigns as $camp)
                  <tr>
                    <td class="text-start fw-bold"><a href="{{ route('campaigns.show', $camp) }}"
                        class="text-decoration-none text-dark">{{ $camp->name }}</a></td>
                    <td class="text-success">{{ number_format($camp->total_donations) }}</td>
                    <td class="text-danger">{{ number_format($camp->total_expenses) }}</td>
                    <td class="fw-bold {{ $camp->net_balance >= 0 ? 'text-success' : 'text-danger' }}">
                      {{ number_format($camp->net_balance) }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد حملات نشطة حالياً</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">المشاريع النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('projects.index') }}">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">المشروع</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                @forelse($activeProjects as $proj)
                  <tr>
                    <td class="text-start fw-bold"><a href="{{ route('projects.show', $proj) }}"
                        class="text-decoration-none text-dark">{{ $proj->name }}</a></td>
                    <td class="text-success">{{ number_format($proj->total_donations) }}</td>
                    <td class="text-danger">{{ number_format($proj->total_expenses) }}</td>
                    <td class="fw-bold {{ $proj->net_balance >= 0 ? 'text-success' : 'text-danger' }}">
                      {{ number_format($proj->net_balance) }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد مشاريع نشطة حالياً</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  @elseif($isVolunteer ?? false)
    {{-- Volunteer Dashboard --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم المتطوع</h2>
      <div class="d-flex gap-3 align-items-center">
          <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-primary rounded-pill px-3">
              <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
          </a>
          <div class="text-muted small">{{ date('Y-m-d') }}</div>
      </div>
    </div>

    {{-- Row 0: Personal Stats --}}
    <div class="row g-3 mb-4">
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">إجمالي الساعات</div>
                  <i class="bi bi-clock-history text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0">{{ number_format($volunteerStats['total_hours'], 1) }}</div>
              <div class="small text-muted mt-1">ساعة تطوعية</div>
          </div>
      </div>
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الجهة المسندة</div>
                  <i class="bi bi-building text-success opacity-50 fs-5"></i>
              </div>
              <div class="h5 fw-bold text-dark mb-0 text-truncate">{{ $volunteerStats['current_assignment'] }}</div>
          </div>
      </div>
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">تاريخ الانضمام</div>
                  <i class="bi bi-calendar-event text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h5 fw-bold text-dark mb-0">{{ $volunteerStats['join_date'] }}</div>
          </div>
      </div>
    </div>

    {{-- Row 1: Notifications --}}
    <div class="row g-3 mb-3">
      <div class="col-md-12">
        <div class="card p-3 shadow-sm border-0">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          @forelse($notifications as $n)
            <div class="alert alert-{{ $n['type'] }} py-2 mb-2 small shadow-sm border-0">{{ $n['text'] }}</div>
          @empty
            <div class="text-muted text-center py-2">لا توجد تنبيهات</div>
          @endforelse
        </div>
      </div>
    </div>

    {{-- Row 2: Tasks & Activity History --}}
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">مهامي الحالية</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('volunteer-tasks.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @forelse($volunteerTasks as $t)
              <li>
                <div>
                  <div class="fw-bold">{{ $t->title ?? ('مهمة #' . $t->id) }}</div>
                  @if($t->due_date)
                    <div class="small {{ $t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted' }}">
                      <i class="bi bi-calendar-event me-1"></i>{{ $t->due_date->format('Y-m-d') }}
                    </div>
                  @endif
                </div>
                <span class="badge bg-secondary-subtle text-body border">{{ $t->status ?? '—' }}</span>
              </li>
            @empty
               <li class="text-center text-muted py-3">لا توجد مهام مسندة إليك</li>
            @endforelse
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
             <h5 class="mb-0 fw-bold">سجل الأنشطة (آخر 5)</h5>
             <a href="{{ route('volunteer-hours.index') }}" class="btn btn-sm btn-outline-secondary rounded-pill px-3">عرض الكل</a>
          </div>
          <div class="table-responsive">
              <table class="table table-sm table-hover align-middle mb-0" style="font-size: 0.85rem;">
                  <thead class="text-muted">
                      <tr>
                          <th>التاريخ</th>
                          <th>النشاط</th>
                          <th class="text-center">الساعات</th>
                      </tr>
                  </thead>
                  <tbody>
                      @forelse($volunteerStats['activities'] as $act)
                        <tr>
                            <td>{{ $act->date ? $act->date->format('Y-m-d') : '—' }}</td>
                            <td class="text-truncate" style="max-width: 150px;">{{ $act->task ?? '—' }}</td>
                            <td class="text-center fw-bold">{{ $act->hours }}</td>
                        </tr>
                      @empty
                        <tr><td colspan="3" class="text-center text-muted py-3">لا توجد أنشطة مسجلة</td></tr>
                      @endforelse
                  </tbody>
              </table>
          </div>
        </div>
      </div>
    </div>

    {{-- Row 3: Volunteer Honor Board --}}
    <div class="row g-3 mb-3">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                @foreach(collect($evaluations)->sortByDesc('score')->take(5) as $ev)
                  <tr>
                    <td class="fw-bold">{{ $ev['name'] }}</td>
                    <td class="text-center">{{ number_format($ev['hours'], 1) }}</td>
                    <td class="text-center">{{ $ev['attendance'] }}</td>
                    <td class="text-center">{{ $ev['tasks'] }}</td>
                    <td class="text-center fw-bold text-primary">{{ $ev['score'] }}</td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ min($ev['score'], 100) }}%">
                        </div>
                      </div>
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  @else
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة التحكم</h2>

      <div class="text-muted small">{{ date('Y-m-d') }}</div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md"><a href="{{ route('donors.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتبرعون</div>
          <div class="display-6 fw-bold text-dark">{{ $donorsCount }}</div>
        </a></div>
      <div class="col-md"><a href="{{ route('beneficiaries.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المستفيدون</div>
          <div class="display-6 fw-bold text-dark">{{ $beneficiariesCount }}</div>
        </a></div>
      <div class="col-md"><a href="{{ route('warehouses.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المخازن</div>
          <div class="display-6 fw-bold text-dark">{{ $warehousesCount }}</div>
        </a></div>
      <div class="col-md"><a href="{{ route('volunteers.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتطوعون</div>
          <div class="display-6 fw-bold text-dark">{{ $volunteersCount }}</div>
        </a></div>
      <div class="col-md"><a href="{{ route('users.index') }}?type=employee"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">الموظفون</div>
          <div class="display-6 fw-bold text-dark">{{ $employeesCount }}</div>
        </a></div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-3"><a href="{{ route('donations.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات نقدية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-primary-custom">{{ number_format($cashMonth, 2) }}</div>
        </a></div>
      <div class="col-md-3"><a href="{{ route('donations.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات عينية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-success">{{ number_format($inKindMonth, 2) }}</div>
        </a></div>
      <div class="col-md-3"><a href="{{ route('expenses.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">مصروفات (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-danger">{{ number_format($expensesMonth, 2) }}</div>
        </a></div>
      <div class="col-md-3"><a href="{{ route('reports.index') }}"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">صافي التدفق</div>
          <div class="h4 mb-0 fw-bold text-dark">{{ number_format($netFlowMonth, 2) }}</div>
        </a></div>
    </div>

    @php $maxVal = max(array_merge($cashSeries, $inKindSeries));
    $maxVal = $maxVal > 0 ? $maxVal : 1; @endphp
    <div class="row g-3 mb-3">
      <div class="col-md-8">
        <div class="card chart-wrap p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">توزيع التبرعات آخر 12 شهرًا</h5>
            <span class="chip">نقدي مقابل عيني</span>
          </div>
          <div class="bar-grid">
            @for($i = 0; $i < count($months); $i++)
              @php $cm = $cashSeries[$i];
                $km = $inKindSeries[$i];
                $ch = max(round(($cm / $maxVal) * 180), 4);
              $kh = max(round(($km / $maxVal) * 180), 4); @endphp
              <div style="display:flex;gap:4px;align-items:flex-end;flex:1;justify-content:center;">
                <div class="bar cash" style="height:{{ $ch }}px" title="{{ $months[$i] }}: {{ number_format($cm, 2) }}"
                  data-bs-toggle="tooltip"></div>
                <div class="bar kind" style="height:{{ $kh }}px" title="{{ $months[$i] }}: {{ number_format($km, 2) }}"
                  data-bs-toggle="tooltip"></div>
              </div>
            @endfor
          </div>
          <div class="bar-labels mt-2 small text-muted text-center">
            @foreach($months as $m)<span style="flex:1">{{ $m }}</span>@endforeach
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">حالة المستفيدين</h5>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($beneficiaryStatus as $s)
              <li><span>{{ $s['status'] }}</span><span class="chip">{{ $s['count'] }}</span></li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    <div class="row g-3">
      <div class="col-md-8">
        <div class="card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر سجلات النظام</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('audits.index') }}">عرض الكل</a>
          </div>
          @if($isAdmin)
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="bg-transparent">
                  <tr>
                    <th>#</th>
                    <th>التاريخ</th>
                    <th>المستخدم</th>
                    <th>الطريقة</th>
                    <th>المسار</th>
                    <th>الحالة</th>
                    <th>IP</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($audits as $a)
                    <tr>
                      <td>{{ $a->id }}</td>
                      <td>{{ optional($a->created_at)->format('Y-m-d H:i') }}</td>
                      <td>{{ optional($audUserMap->get($a->user_id))->name ?? '—' }}</td>
                      <td><span class="badge bg-secondary-subtle text-body border">{{ $a->method }}</span></td>
                      <td class="small text-muted">{{ Str::limit($a->path, 20) }}</td>
                      <td>{{ $a->status_code ?? '—' }}</td>
                      <td><span class="small text-muted">{{ $a->ip ?? '—' }}</span></td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          @else
            <div class="text-muted py-3 text-center">لا تُعرض السجلات إلا للمسؤولين</div>
          @endif
        </div>
      </div>
      <div class="col-md-4">
        <div class="card p-3 h-100">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          @forelse($notifications as $n)
            <div class="alert alert-{{ $n['type'] }} py-2 mb-2 small shadow-sm border-0">{{ $n['text'] }}</div>
          @empty
            <div class="text-muted text-center py-4">لا توجد تنبيهات</div>
          @endforelse
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر التبرعات</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="{{ route('donations.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestDonations as $d)
              <li>
                <div>
                  <div class="fw-bold">
                    @if($d->donor_id)
                      <a href="{{ route('donors.show', $d->donor_id) }}"
                        class="text-decoration-none text-dark">{{ $d->donor?->name ?? '—' }}</a>
                    @else
                      {{ $d->donor?->name ?? '—' }}
                    @endif
                  </div>
                  <div class="small text-muted">{{ $d->type === 'cash' ? 'نقدي' : 'عيني' }}</div>
                </div>
                <span
                  class="chip">{{ ($d->type === 'cash') ? number_format($d->amount, 2) : number_format($d->estimated_value, 2) }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المهام</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="{{ route('tasks.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestTasks as $t)
              <li>
                <div>
                  <div class="fw-bold">{{ $t->title ?? ('مهمة #' . $t->id) }}</div>
                  @if($t->due_date)
                    <div class="small {{ $t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted' }}">
                      <i class="bi bi-calendar-event me-1"></i>{{ $t->due_date->format('Y-m-d') }}
                    </div>
                  @endif
                </div>
                <span class="badge bg-secondary-subtle text-body border">{{ $t->status ?? '—' }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">حضور اليوم</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="{{ route('volunteer-attendance.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestAttendance as $a)
              <li><span>{{ $a->user?->name ?? '—' }}</span><span
                  class="small text-muted">{{ $a->date?->format('H:i') ?? '—' }}</span></li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($topDonors as $td)
              <li>
                @if(!empty($td['id']))
                  <a href="{{ route('donors.show', $td['id']) }}" class="text-decoration-none text-dark">{{ $td['name'] }}</a>
                @else
                  <span>{{ $td['name'] }}</span>
                @endif
                <span class="chip">{{ number_format($td['total'], 2) }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary">{{ $cashMonthPct }}%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success">{{ $inKindMonthPct }}%</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                @foreach(collect($evaluations)->sortByDesc('score')->take(5) as $ev)
                  <tr>
                    <td class="fw-bold">{{ $ev['name'] }}</td>
                    <td class="text-center">{{ number_format($ev['hours'], 1) }}</td>
                    <td class="text-center">{{ $ev['attendance'] }}</td>
                    <td class="text-center">{{ $ev['tasks'] }}</td>
                    <td class="text-center fw-bold text-primary">{{ $ev['score'] }}</td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ min($ev['score'], 100) }}%">
                        </div>
                      </div>
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المصروفات</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('expenses.index') }}">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @foreach($latestExpenses as $ex)
              <li>
                <div>
                  <div class="fw-bold">{{ $ex->category ?? 'غير محدد' }}</div>
                  <div class="small text-muted">{{ $ex->created_at->format('Y-m-d') }} | {{ $ex->creator?->name ?? '—' }}
                  </div>
                </div>
                <span class="chip text-danger">{{ number_format($ex->amount, 2) }} {{ $ex->currency }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع المصروفات (هذا الشهر)</h5>
          @if(count($expenseByCat) > 0)
            <ul class="list-unstyled list-simple mb-0">
              @foreach($expenseByCat as $ec)
                <li>
                  <span>{{ $ec->category ?? 'أخرى' }}</span>
                  <span class="fw-bold text-dark">{{ number_format($ec->total, 2) }}</span>
                </li>
              @endforeach
            </ul>
          @else
            <div class="text-center py-4 text-muted">لا توجد مصروفات هذا الشهر</div>
          @endif
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">الحملات النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('campaigns.index') }}">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">الحملة</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                @forelse($activeCampaigns as $camp)
                  <tr>
                    <td class="text-start fw-bold"><a href="{{ route('campaigns.show', $camp) }}"
                        class="text-decoration-none text-dark">{{ $camp->name }}</a></td>
                    <td class="text-success">{{ number_format($camp->total_donations) }}</td>
                    <td class="text-danger">{{ number_format($camp->total_expenses) }}</td>
                    <td class="fw-bold {{ $camp->net_balance >= 0 ? 'text-success' : 'text-danger' }}">
                      {{ number_format($camp->net_balance) }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد حملات نشطة حالياً</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">المشاريع النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('projects.index') }}">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">المشروع</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                @forelse($activeProjects as $proj)
                  <tr>
                    <td class="text-start fw-bold"><a href="{{ route('projects.show', $proj) }}"
                        class="text-decoration-none text-dark">{{ $proj->name }}</a></td>
                    <td class="text-success">{{ number_format($proj->total_donations) }}</td>
                    <td class="text-danger">{{ number_format($proj->total_expenses) }}</td>
                    <td class="fw-bold {{ $proj->net_balance >= 0 ? 'text-success' : 'text-danger' }}">
                      {{ number_format($proj->net_balance) }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد مشاريع نشطة حالياً</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">أعلى 5 أصناف في المخزون</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="{{ route('warehouses.index') }}">عرض
              الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            @forelse($inventoryLevels as $inv)
              <li>
                <div>
                  <div class="fw-bold">{{ $inv->item->name ?? '—' }}</div>
                  <div class="small text-muted">{{ $inv->item->category ?? '' }}</div>
                </div>
                <span class="chip">{{ $inv->current_stock }}</span>
              </li>
            @empty
              <li class="text-center text-muted py-2">المخزون فارغ</li>
            @endforelse
          </ul>
        </div>
      </div>
    </div>
  @endif
@endsection