@extends('layouts.app')
@section('content')
    <div class="card p-4">
        <h5 class="mb-3">تعديل مندوب</h5>
        <form method="POST" action="{{ route('delegates.update', $delegate) }}" enctype="multipart/form-data">@csrf
            @method('PUT')
            <div class="row g-3">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">الموظف (اختياري)</label>
                        <select name="user_id" class="form-select" id="employeeSelect">
                            <option value="">-- اختر موظف --</option>
                            @foreach($employees as $emp)
                                <option value="{{ $emp->id }}" data-phone="{{ $emp->phone }}" data-name="{{ $emp->name }}"
                                    @selected($delegate->user_id == $emp->id)>{{ $emp->name }}</option>
                            @endforeach
                        </select>
                        <div class="form-text">عند اختيار موظف، سيتم تعبئة البيانات تلقائيًا</div>
                    </div>
                    <div class="col-md-6"></div> <!-- Spacer -->

                    <div class="col-md-6"><label class="form-label">الاسم</label><input name="name" id="nameInput"
                            class="form-control" value="{{ $delegate->name }}"></div>
                    <div class="col-md-6"><label class="form-label">الهاتف</label><input name="phone" id="phoneInput"
                            class="form-control" value="{{ $delegate->phone }}"></div>
                    <script>
                        document.getElementById('employeeSelect').addEventListener('change', function () {
                            var opt = this.options[this.selectedIndex];
                            var name = opt.getAttribute('data-name');
                            var phone = opt.getAttribute('data-phone');
                            if (name) document.getElementById('nameInput').value = name;
                            if (phone) document.getElementById('phoneInput').value = phone;
                        });
                    </script>
                    <div class="col-md-6"><label class="form-label">خط السير</label><select name="route_id"
                            class="form-select">
                            <option value="">—</option>@foreach($routes as $r)<option value="{{ $r->id }}"
                            @selected($delegate->route_id == $r->id)>{{ $r->name }}</option>@endforeach
                        </select></div>
                    <div class="col-md-6">
                        <label class="form-label">الصورة الشخصية</label>
                        <input type="file" name="profile_photo" class="form-control" accept="image/*">
                        @if($delegate->profile_photo_path)
                            <div class="mt-2">
                                <img src="{{ asset('storage/' . $delegate->profile_photo_path) }}" alt="Current Photo"
                                    class="img-thumbnail" style="height: 100px;">
                            </div>
                        @endif
                    </div>
                </div>
                <div class="mt-3"><button class="btn btn-primary">حفظ</button><a
                        href="{{ route('delegates.show', $delegate) }}" class="btn btn-light">رجوع</a></div>
        </form>
    </div>
@endsection