@extends('layouts.app')
@section('content')
<div class="container-fluid p-0">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-body">سجل حضور الموظفين</h3>
        <a href="{{ route('employee-attendance.create') }}" class="btn btn-primary px-4 rounded-pill shadow-sm">
            <i class="bi bi-plus-lg me-1"></i> تسجيل حضور
        </a>
    </div>

    <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr class="text-secondary small text-uppercase">
                            <th class="py-3 px-4">الموظف</th>
                            <th class="py-3 px-4">التاريخ</th>
                            <th class="py-3 px-4">وقت الدخول</th>
                            <th class="py-3 px-4">وقت الخروج</th>
                            <th class="py-3 px-4">ملاحظات</th>
                            <th class="py-3 px-4">التقييم</th>
                            <th class="py-3 px-4 text-end">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($records as $r)
                        <tr>
                            <td class="px-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-initials bg-primary-subtle text-primary rounded-circle me-2 d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; font-weight: bold;">
                                        {{ strtoupper(substr($r->user?->name ?? 'U', 0, 1)) }}
                                    </div>
                                    <span class="fw-medium">{{ $r->user?->name }}</span>
                                </div>
                            </td>
                            <td class="px-4 text-muted">{{ $r->date->format('Y-m-d') }}</td>
                            <td class="px-4"><span class="badge bg-success-subtle text-success rounded-pill px-3">{{ $r->check_in_at ?? '—' }}</span></td>
                            <td class="px-4"><span class="badge bg-danger-subtle text-danger rounded-pill px-3">{{ $r->check_out_at ?? '—' }}</span></td>
                            <td class="px-4 text-muted small">{{ Str::limit($r->notes, 30) ?? '—' }}</td>
                            <td class="px-4">
                                @if($r->rating)
                                    <span class="text-warning" title="{{ $r->evaluation_notes }}">
                                        @for($i=1; $i<=5; $i++)
                                            <i class="bi bi-star{{ $i <= $r->rating ? '-fill' : '' }}"></i>
                                        @endfor
                                    </span>
                                @else
                                    <span class="text-muted small">غير مقيم</span>
                                @endif
                            </td>
                            <td class="px-4 text-end">
                                <div class="btn-group">
                                    <a class="btn btn-sm btn-outline-secondary" href="{{ route('employee-attendance.edit',$r) }}" title="تعديل"><i class="bi bi-pencil"></i></a>
                                    <form class="d-inline" method="POST" action="{{ route('employee-attendance.destroy',$r) }}" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                        @csrf @method('DELETE')
                                        <button class="btn btn-sm btn-outline-danger" title="حذف"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center py-5 text-muted">
                                <i class="bi bi-calendar-x display-4 mb-3 d-block opacity-50"></i>
                                لا توجد سجلات حضور حالياً
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($records->hasPages())
        <div class="card-footer bg-transparent border-0 py-3">
            {{ $records->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
