@extends('layouts.app')
@section('content')
<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center border-bottom pb-3 mb-3">
        <h5 class="mb-0">تفاصيل حضور موظف</h5>
        <a class="btn btn-secondary" href="{{ route('employee-attendance.edit',$rec) }}">تعديل</a>
    </div>
    <div class="row g-3">
        <div class="col-md-6">
            <label class="text-muted small">الموظف</label>
            <div class="fw-bold">{{ $rec->user?->name }}</div>
        </div>
        <div class="col-md-6">
            <label class="text-muted small">التاريخ</label>
            <div class="fw-bold">{{ $rec->date->format('Y-m-d') }}</div>
        </div>
        <div class="col-md-6">
            <label class="text-muted small">وقت الدخول</label>
            <div class="fw-bold">{{ $rec->check_in_at ?? '—' }}</div>
        </div>
        <div class="col-md-6">
            <label class="text-muted small">وقت الخروج</label>
            <div class="fw-bold">{{ $rec->check_out_at ?? '—' }}</div>
        </div>
        <div class="col-12">
            <label class="text-muted small">ملاحظات</label>
            <div class="fw-bold">{{ $rec->notes ?? '—' }}</div>
        </div>
        <div class="col-12 mt-3">
            <h6 class="text-primary border-bottom pb-2 mb-3">تقييم الأداء</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="text-muted small">التقييم</label>
                    <div class="fw-bold">
                        @if($rec->rating)
                            <span class="text-warning">
                                @for($i=1; $i<=5; $i++)
                                    <i class="bi bi-star{{ $i <= $rec->rating ? '-fill' : '' }}"></i>
                                @endfor
                            </span>
                        @else
                            <span class="text-muted">غير مقيم</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-12">
                    <label class="text-muted small">ملاحظات التقييم</label>
                    <div class="fw-bold">{{ $rec->evaluation_notes ?? '—' }}</div>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-4 pt-3 border-top">
        <a href="{{ route('employee-attendance.index') }}" class="btn btn-light">رجوع</a>
    </div>
</div>
@endsection
