@extends('layouts.app')

@section('content')
<div class="container d-flex flex-column justify-content-center align-items-center" style="min-height: 70vh;">
    <div class="text-center">
        <div class="mb-4 position-relative d-inline-block">
            <i class="bi bi-shield-lock display-1 text-danger opacity-75"></i>
            <i class="bi bi-x-circle-fill position-absolute bottom-0 end-0 text-danger bg-body rounded-circle" style="font-size: 2rem; border: 4px solid var(--bs-body-bg);"></i>
        </div>
        <h1 class="display-4 fw-bold text-danger mb-2">403</h1>
        <h2 class="h3 mb-3 fw-bold">عذراً، ليس لديك صلاحية للوصول</h2>
        <p class="text-muted mb-4 lead" style="max-width: 600px; margin: 0 auto;">
            لا تمتلك الصلاحيات اللازمة لعرض هذه الصفحة أو تنفيذ هذا الإجراء.
            <br>
            @if($exception->getMessage())
                <span class="d-inline-block mt-2 p-2 bg-danger-subtle text-danger rounded border border-danger-subtle fs-6 font-monospace">
                    {{ $exception->getMessage() }}
                </span>
            @endif
        </p>
        <div class="d-flex justify-content-center gap-3">
            <a href="{{ url('/') }}" class="btn btn-primary px-4 py-2">
                <i class="bi bi-house-door me-2"></i> الرئيسية
            </a>
            <button onclick="history.back()" class="btn btn-outline-secondary px-4 py-2">
                <i class="bi bi-arrow-right me-2"></i> رجوع
            </button>
        </div>
    </div>
</div>
@endsection
