@extends('layouts.app')
@section('content')
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">المصروفات</h4>
    <a href="{{ route('expenses.create') }}" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة مصروف</a>
  </div>
  <form method="GET" class="card p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-3">
        <label class="form-label">الشهر</label>
        <select name="month" class="form-select">
          <option value="">الكل</option>
          @foreach(range(1, 12) as $m)
            <option value="{{ $m }}" @selected(request('month') == $m)>{{ $m }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">السنة</label>
        <select name="year" class="form-select">
          <option value="">الكل</option>
          @foreach(range(date('Y'), 2023) as $y)
            <option value="{{ $y }}" @selected(request('year') == $y)>{{ $y }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select">
          <option value="">الكل</option>
          @foreach(\App\Models\Project::orderBy('name')->get() as $p)
            <option value="{{ $p->id }}" @selected(request('project_id') == $p->id)>{{ $p->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3 d-flex gap-2">
        <button class="btn btn-primary flex-fill">تصفية</button>
        <a href="{{ route('expenses.export', request()->query()) }}" class="btn btn-outline-secondary">تصدير CSV</a>
      </div>
    </div>
  </form>
  <div class="table-responsive">
    <table class="table table-striped">
      <thead>
        <tr>
          <th>#</th>
          <th>النوع</th>
          <th>التصنيف</th>
          <th>المبلغ</th>
          <th>المستفيد</th>
          <th>المشروع</th>
          <th>الحملة</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        @foreach($expenses as $e)
          <tr>
            <td>{{ $e->id }}</td>
            <td>{{ $e->type }}</td>
            <td>{{ $e->category ?? '—' }}</td>
            <td>{{ $e->amount }} {{ $e->currency }}</td>
            <td>{{ $e->beneficiary?->full_name ?? '—' }}</td>
            <td>{{ $e->project?->name ?? '—' }}</td>
            <td>{{ $e->campaign?->name ?? '—' }}</td>
            <td class="text-end"><a class="btn btn-outline-primary btn-sm" href="{{ route('expenses.show', $e) }}">عرض</a><a
                class="btn btn-outline-secondary btn-sm" href="{{ route('expenses.edit', $e) }}">تعديل</a>
              <form class="d-inline" method="POST" action="{{ route('expenses.destroy', $e) }}">@csrf
                @method('DELETE')<button class="btn btn-outline-danger btn-sm">حذف</button></form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  <div class="mt-3">{{ $expenses->links() }}</div>
@endsection