@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-body mb-0">حركات المخزون</h2>
        <div class="d-flex gap-2">
            <a href="{{ route('inventory-transactions.create-transfer') }}" class="btn btn-outline-primary px-3">
                <i class="bi bi-arrow-left-right me-2"></i> تحويل
            </a>
            <a href="{{ route('inventory-transactions.create-reconcile') }}" class="btn btn-outline-warning px-3 text-dark">
                <i class="bi bi-clipboard-check me-2"></i> جرد/تسوية
            </a>
            <a href="{{ route('inventory-transactions.create') }}" class="btn btn-primary px-4">
                <i class="bi bi-plus-lg me-2"></i> إضافة حركة
            </a>
        </div>
    </div>

    <!-- Stats & Delegates -->
    <div class="row g-4 mb-4">
        <!-- Daily Stats -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-4">
                    <h5 class="card-title fw-bold mb-3">ملخص اليوم</h5>
                    <div class="text-muted small mb-3">{{ $stats['date'] }}</div>
                    
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="text-muted">عدد الحركات</div>
                        <div class="fw-bold fs-5">{{ $stats['trips_today'] }}</div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-muted">القيمة المقدرة</div>
                        <div class="fw-bold fs-5 text-success">{{ number_format($stats['value_today'], 2) }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delegate Stats -->
        <div class="col-md-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 pt-4 px-4 pb-0">
                    <h5 class="card-title fw-bold mb-0">نشاط المندوبين (تحصيل)</h5>
                </div>
                <div class="card-body p-4">
                    @if(count($stats['delegateDaily']) > 0)
                        <div class="row g-3">
                            @foreach($stats['delegateDaily'] as $r)
                                <div class="col-sm-6 col-lg-4">
                                    <div class="p-3 bg-body-tertiary rounded-3 h-100">
                                        <div class="fw-bold mb-2 text-primary">{{ $stats['delegatesMap'][$r->delegate_id]->name ?? 'غير معروف' }}</div>
                                        <div class="small mb-1">
                                            <span class="text-muted">اليوم:</span> 
                                            <span class="fw-medium">{{ (int)$r->count }} عملية</span>
                                        </div>
                                        <div class="small mb-2">
                                            <span class="fw-bold text-success">{{ number_format((float)$r->total, 2) }}</span>
                                        </div>
                                        
                                        @php($mm = $stats['delegateMonthly']->firstWhere('delegate_id', $r->delegate_id))
                                        <div class="border-top pt-2 mt-2">
                                            <div class="small text-muted mb-1">الشهر الحالي</div>
                                            <div class="d-flex justify-content-between small">
                                                <span>{{ (int)($mm->count ?? 0) }} عملية</span>
                                                <span class="fw-medium">{{ number_format((float)($mm->total ?? 0), 2) }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center text-muted py-3">
                            لا يوجد نشاط للمندوبين اليوم
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body p-4">
            <form action="{{ route('inventory-transactions.index') }}" method="GET">
                <div class="row g-3 align-items-end">
                    <div class="col-md-3">
                        <label class="form-label small text-muted">نوع الحركة</label>
                        <select name="type" class="form-select">
                            <option value="">الكل</option>
                            <option value="in" {{ request('type') == 'in' ? 'selected' : '' }}>وارد (In)</option>
                            <option value="out" {{ request('type') == 'out' ? 'selected' : '' }}>صادر (Out)</option>
                            <option value="transfer" {{ request('type') == 'transfer' ? 'selected' : '' }}>نقل (Transfer)</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small text-muted">المخزن</label>
                        <select name="warehouse_id" class="form-select">
                            <option value="">الكل</option>
                            @foreach($warehouses as $id => $name)
                                <option value="{{ $id }}" {{ request('warehouse_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small text-muted">الصنف</label>
                        <select name="item_id" class="form-select">
                            <option value="">الكل</option>
                            @foreach($items as $id => $name)
                                <option value="{{ $id }}" {{ request('item_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-secondary w-100">تصفية النتائج</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="ps-4">#</th>
                            <th>التاريخ</th>
                            <th>النوع</th>
                            <th>الصنف</th>
                            <th>الكمية</th>
                            <th>المخزن</th>
                            <th>تفاصيل المصدر / الوجهة</th>
                            <th class="text-end pe-4">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $t)
                            <tr>
                                <td class="ps-4 text-muted small">{{ $t->id }}</td>
                                <td>{{ $t->created_at->format('Y-m-d') }} <br> <small class="text-muted">{{ $t->created_at->format('H:i') }}</small></td>
                                <td>
                                    @if($t->type == 'in')
                                        <span class="badge bg-success-subtle text-success rounded-pill px-3">وارد</span>
                                    @elseif($t->type == 'out')
                                        <span class="badge bg-danger-subtle text-danger rounded-pill px-3">صادر</span>
                                    @elseif($t->type == 'transfer')
                                        <span class="badge bg-info-subtle text-info rounded-pill px-3">نقل (قديم)</span>
                                    @elseif($t->type == 'transfer_in')
                                        <span class="badge bg-info-subtle text-info rounded-pill px-3">تحويل (وارد)</span>
                                    @elseif($t->type == 'transfer_out')
                                        <span class="badge bg-warning-subtle text-warning rounded-pill px-3">تحويل (صادر)</span>
                                    @elseif($t->type == 'stock_count_shortage')
                                        <span class="badge bg-danger-subtle text-danger rounded-pill px-3">عجز جرد</span>
                                    @elseif($t->type == 'stock_count_increase')
                                        <span class="badge bg-success-subtle text-success rounded-pill px-3">زيادة جرد</span>
                                    @elseif($t->type == 'reconciliation')
                                        <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3">تسوية</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="fw-medium">{{ $t->item->name ?? '—' }}</div>
                                    @if($t->item && $t->item->sku)
                                        <div class="small text-muted font-monospace">{{ $t->item->sku }}</div>
                                    @endif
                                </td>
                                <td>
                                    <span class="fw-bold">{{ $t->quantity }}</span>
                                    <small class="text-muted">{{ $t->item->unit ?? '' }}</small>
                                </td>
                                <td>{{ $t->warehouse->name ?? '—' }}</td>
                                <td>
                                    <div class="small">
                                        @if($t->sourceDonation)
                                            <div class="text-muted">تبرع من:</div>
                                            <div class="fw-medium">{{ $t->sourceDonation->donor->name ?? 'فاعل خير' }}</div>
                                            @if($t->sourceDonation->delegate)
                                                <div class="text-muted text-xs">بواسطة: {{ $t->sourceDonation->delegate->name }}</div>
                                            @endif
                                        @elseif($t->beneficiary)
                                            <div class="text-muted">إلى المستفيد:</div>
                                            <div class="fw-medium">{{ $t->beneficiary->full_name }}</div>
                                        @elseif($t->project)
                                            <div class="text-muted">مشروع:</div>
                                            <div class="fw-medium">{{ $t->project->name }}</div>
                                        @elseif($t->reference)
                                            <div class="text-muted">مرجع:</div>
                                            <div class="font-monospace">{{ $t->reference }}</div>
                                        @else
                                            <span class="text-muted">—</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="text-end pe-4">
                                    <div class="btn-group">
                                        <a href="{{ route('inventory-transactions.show', $t) }}" class="btn btn-sm btn-outline-secondary" title="عرض">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('inventory-transactions.edit', $t) }}" class="btn btn-sm btn-outline-secondary" title="تعديل">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" title="حذف" 
                                                onclick="if(confirm('هل أنت متأكد من حذف هذه الحركة؟')) document.getElementById('delete-t-{{ $t->id }}').submit()">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                    <form id="delete-t-{{ $t->id }}" action="{{ route('inventory-transactions.destroy', $t) }}" method="POST" class="d-none">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="bi bi-clipboard-x fs-1 d-block mb-3"></i>
                                        <h5>لا توجد حركات</h5>
                                        <p class="mb-0">لم يتم العثور على حركات مخزون تطابق خيارات البحث.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($transactions->hasPages())
        <div class="card-footer bg-transparent border-0 py-3">
            {{ $transactions->withQueryString()->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
