@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="{{ route('items.index') }}" class="text-decoration-none">الأصناف</a></li>
                    <li class="breadcrumb-item active" aria-current="page">إضافة صنف جديد</li>
                </ol>
            </nav>
            <h2 class="fw-bold text-dark mb-0">إضافة صنف</h2>
        </div>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
            <form method="POST" action="{{ route('items.store') }}">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-medium">اسم الصنف <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required placeholder="مثال: أرز، سكر، زيت...">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-medium">SKU (رمز الصنف)</label>
                        <input type="text" name="sku" class="form-control" placeholder="اختياري">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-medium">الوحدة</label>
                        <input type="text" name="unit" class="form-control" placeholder="مثال: كيلو، كرتونة، قطعة...">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-medium">القيمة التقديرية (EGP)</label>
                        <input type="number" step="0.01" name="estimated_value" class="form-control" placeholder="0.00">
                    </div>
                </div>

                <div class="mt-4 pt-3 border-top d-flex gap-2">
                    <button type="submit" class="btn btn-primary px-4">
                        <i class="bi bi-save me-1"></i> حفظ الصنف
                    </button>
                    <a href="{{ route('items.index') }}" class="btn btn-light px-4">إلغاء</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
