@extends('layouts.app')
@section('content')
<div class="d-flex justify-content-between mb-3">
    <h4>القيود اليومية</h4>
    <a href="{{ route('journal-entries.create') }}" class="btn btn-primary">إضافة قيد</a>
</div>
<div class="card p-3">
    <table class="table table-bordered">
        <thead class="bg-transparent">
            <tr>
                <th>#</th>
                <th>التاريخ</th>
                <th>الوصف</th>
                <th>النوع</th>
                <th>إجمالي</th>
                <th>الحالة</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach($entries as $entry)
            <tr>
                <td>{{ $entry->id }}</td>
                <td>{{ $entry->date->format('Y-m-d') }}</td>
                <td>{{ Str::limit($entry->description, 50) }}</td>
                <td>{{ $entry->entry_type }}</td>
                <td>{{ $entry->lines->sum('debit') }}</td>
                <td>
                    @if($entry->locked) <span class="badge bg-secondary">مغلق</span> @else <span class="badge bg-success">مفتوح</span> @endif
                </td>
                <td>
                    <a href="{{ route('journal-entries.show', $entry) }}" class="btn btn-sm btn-outline-info">عرض</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $entries->links() }}
</div>
@endsection
