@extends('layouts.app')
@section('content')
<div class="card p-4">
    <div class="d-flex justify-content-between mb-3">
        <h5>تفاصيل القيد #{{ $journalEntry->id }}</h5>
        <a href="{{ route('journal-entries.index') }}" class="btn btn-light">رجوع</a>
    </div>
    
    <div class="row mb-3">
        <div class="col-md-3"><strong>التاريخ:</strong> {{ $journalEntry->date->format('Y-m-d') }}</div>
        <div class="col-md-3"><strong>النوع:</strong> {{ $journalEntry->entry_type }}</div>
        <div class="col-md-6"><strong>الوصف:</strong> {{ $journalEntry->description }}</div>
    </div>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>كود الحساب</th>
                <th>اسم الحساب</th>
                <th>مدين</th>
                <th>دائن</th>
            </tr>
        </thead>
        <tbody>
            @foreach($journalEntry->lines as $line)
            <tr>
                <td>{{ $line->account->code }}</td>
                <td>{{ $line->account->name }}</td>
                <td>{{ number_format($line->debit, 2) }}</td>
                <td>{{ number_format($line->credit, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2">الإجمالي</th>
                <th>{{ number_format($journalEntry->lines->sum('debit'), 2) }}</th>
                <th>{{ number_format($journalEntry->lines->sum('credit'), 2) }}</th>
            </tr>
        </tfoot>
    </table>
</div>
@endsection
