<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginWebController;
use App\Http\Controllers\HrEvaluationWebController;
use App\Http\Controllers\GuestHouseWebController;
use App\Http\Controllers\DashboardWebController;
use App\Http\Controllers\DonorWebController;
use App\Http\Controllers\DonationWebController;
use App\Http\Controllers\WarehouseWebController;
use App\Http\Controllers\ItemWebController;
use App\Http\Controllers\InventoryTransactionWebController;
use App\Http\Controllers\BeneficiaryWebController;
use App\Http\Controllers\AccountWebController;
use App\Http\Controllers\JournalEntryWebController;
use App\Http\Controllers\ReportsWebController;
use App\Http\Controllers\UserWebController;
use App\Http\Controllers\RoleWebController;
use App\Http\Controllers\ComplaintWebController;
use App\Http\Controllers\VolunteerHourWebController;
use App\Http\Controllers\PayrollWebController;
use App\Http\Controllers\VolunteerAttendanceWebController;
use App\Http\Controllers\EmployeeAttendanceWebController;
use App\Http\Controllers\TaskWebController;
use App\Http\Controllers\VolunteerTaskWebController;
use App\Http\Controllers\EmployeeTaskWebController;
use App\Http\Controllers\VolunteerWebController;
use App\Http\Controllers\ProjectWebController;
use App\Http\Controllers\CampaignWebController;
use App\Http\Controllers\ExpenseWebController;
use App\Http\Controllers\AuditWebController;
use App\Http\Controllers\NotificationWebController;
use App\Http\Controllers\FinancialClosureWebController;
use App\Http\Controllers\AttachmentWebController;
use App\Http\Controllers\DelegateWebController;
use App\Http\Controllers\TravelRouteWebController;
use App\Http\Controllers\TripWebController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('login', [LoginWebController::class, 'show'])->name('login');
Route::post('login', [LoginWebController::class, 'login'])->name('login.post');
Route::post('logout', [LoginWebController::class, 'logout'])->name('logout');

// DEV ROUTES (Debug only)
Route::get('dev/create-user', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $u = \App\Models\User::firstOrCreate(
        ['email' => 'admin@ensan.local'],
        ['name' => 'System Admin', 'password' => \Illuminate\Support\Facades\Hash::make('admin123'), 'is_employee' => true, 'active' => true]
    );
    // Ensure admin role
    $r = \App\Models\Role::firstOrCreate(['key' => 'admin'], ['name' => 'Administrator']);
    if (!$u->roles->contains($r->id))
        $u->roles()->attach($r->id);
    return "User created/checked: admin@ensan.local / admin123";
});

Route::get('dev/debug-permissions', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $user = auth()->user();
    if (!$user)
        return "Not logged in";

    $html = "<h1>User: {$user->name}</h1>";
    $html .= "<h2>Roles:</h2><ul>";
    foreach ($user->roles as $role) {
        $html .= "<li>{$role->name} ({$role->key})</li>";
    }
    $html .= "</ul>";

    $html .= "<h2>Direct Permissions:</h2><ul>";
    // Assuming you might have direct permissions, if implemented
    $html .= "</ul>";

    $html .= "<h2>All Permissions via Roles:</h2><ul>";
    foreach ($user->roles as $role) {
        foreach ($role->permissions as $perm) {
            $html .= "<li>{$perm->key} (via {$role->name})</li>";
        }
    }
    $html .= "</ul>";

    return $html;
});

Route::get('dev/force-fix-hr-perms', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $html = "<h1>Fixing HR Permissions...</h1>";

    // 1. Find or Create HR Role
    // We want specifically the one with key='hr'
    $hrRole = \App\Models\Role::where('key', 'hr')->first();
    if (!$hrRole) {
        $hrRole = \App\Models\Role::create(['key' => 'hr', 'name' => 'الموارد البشرية']);
        $html .= "Created HR role.<br>";
    } else {
        $html .= "Found HR role (ID: {$hrRole->id}).<br>";
    }

    // 2. Define permissions to attach
    $perms = ['hr.evaluations', 'roles.view'];

    foreach ($perms as $key) {
        // Find or create permission
        $p = \App\Models\Permission::firstOrCreate(['key' => $key], ['name' => $key]);

        // Check if attached
        if (!$hrRole->permissions->contains('id', $p->id)) {
            $hrRole->permissions()->attach($p->id);
            $html .= "Attached '$key' to HR role.<br>";
        } else {
            $html .= "'$key' is already attached to HR role.<br>";
        }
    }

    // 3. Clear cache if any (standard Laravel permission cache?)
    // app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions(); // If using Spatie

    return $html . "<br>Done. Please check 'Roles' page or try accessing the links.";
});

Route::get('dev/fix-dynamic-perms', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $html = "<h1>Fixing Dynamic Permissions & Duplicates...</h1>";

    // 1. Deduplicate 'HR' role if exists
    // We want only 'hr' (lowercase key). If 'HR' (uppercase key) exists, merge or delete.
    $badHr = \App\Models\Role::where('key', 'HR')->first();
    $goodHr = \App\Models\Role::firstOrCreate(['key' => 'hr'], ['name' => 'الموارد البشرية']);

    if ($badHr && $badHr->id !== $goodHr->id) {
        $html .= "Found duplicate HR role (key='HR'). Merging users...<br>";
        foreach ($badHr->users as $u) {
            if (!$u->roles->contains($goodHr->id)) {
                $u->roles()->attach($goodHr->id);
                $html .= "Moved user {$u->name} to 'hr' role.<br>";
            }
        }
        // Move permissions?
        foreach ($badHr->permissions as $p) {
            if (!$goodHr->permissions->contains($p->id)) {
                $goodHr->permissions()->attach($p->id);
            }
        }
        $badHr->delete();
        $html .= "Deleted 'HR' role.<br>";
    }

    // 2. Ensure Admin specific permissions exist
    // 'audits.view', 'notifications.view'
    $adminPerms = ['audits.view', 'notifications.view'];
    $adminRole = \App\Models\Role::where('key', 'admin')->first();

    if ($adminRole) {
        foreach ($adminPerms as $k) {
            $p = \App\Models\Permission::firstOrCreate(['key' => $k], ['name' => $k]);
            if (!$adminRole->permissions->contains($p->id)) {
                $adminRole->permissions()->attach($p->id);
                $html .= "Attached '$k' to Admin.<br>";
            }
        }
    }

    return $html . "<br>Done.";
});

Route::get('dev/ensure-admin', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $user = auth()->user();
    if (!$user)
        return "Please login first.";

    $role = \App\Models\Role::firstOrCreate(['key' => 'admin'], ['name' => 'Administrator']);

    if (!$user->roles->contains($role->id)) {
        $user->roles()->attach($role->id);
    }

    // Ensure admin has all permissions
    $perms = \App\Models\Permission::all();
    $role->permissions()->sync($perms->pluck('id'));

    return "User {$user->name} is now an Admin with all permissions.";
});

Route::get('dev/debug-ibrahim', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    // Try to find the user from the screenshot name
    $user = \App\Models\User::where('name', 'LIKE', '%ابراهيم%')->first();

    if (!$user) {
        return "User 'Ibrahim' not found. Users: <br>" . \App\Models\User::pluck('name')->implode('<br>');
    }

    $html = "<h1>User: {$user->name} (ID: {$user->id})</h1>";

    // --- FIX LOGIC START ---
    $html .= "<h2>Applying Fixes...</h2>";

    // 1. Ensure HR Role exists and has permissions
    $hr = \App\Models\Role::firstOrCreate(['key' => 'hr'], ['name' => 'الموارد البشرية']);
    $perms = ['hr.evaluations', 'roles.view'];
    foreach ($perms as $key) {
        $p = \App\Models\Permission::firstOrCreate(['key' => $key], ['name' => $key]);
        if (!$hr->permissions->contains('id', $p->id)) {
            $hr->permissions()->attach($p->id);
            $html .= "Attached permission '$key' to HR role.<br>";
        } else {
            $html .= "Permission '$key' already attached to HR role.<br>";
        }
    }

    // 2. Assign HR role to User if not present
    // Also ensure no other conflicting roles if necessary, but appending is safer usually.
    // However, if he has NO roles, appending is perfect.
    if (!$user->roles->contains('id', $hr->id)) {
        $user->roles()->attach($hr->id);
        $html .= "<strong>ASSIGNED 'hr' ROLE TO USER.</strong><br>";
        // Refresh user relation
        $user->load('roles.permissions');
    } else {
        $html .= "User already has 'hr' role.<br>";
    }
    // --- FIX LOGIC END ---

    $html .= "<h2>Current Roles:</h2><ul>";
    foreach ($user->roles as $r) {
        $html .= "<li>{$r->name} ({$r->key})</li>";
    }
    $html .= "</ul>";

    $html .= "<h2>Permissions Check:</h2>";
    $checks = ['hr.evaluations', 'roles.view'];
    foreach ($checks as $key) {
        $has = $user->hasPermission($key);
        $html .= "{$key}: " . ($has ? '<span style="color:green">YES</span>' : '<span style="color:red">NO</span>') . "<br>";
    }

    return $html;
});

Route::get('dev/migrate-inventory-schema', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $output = "<h1>Migrating Inventory Schema...</h1>";

    try {
        // 1. Add 'notes' column
        if (!\Illuminate\Support\Facades\Schema::hasColumn('inventory_transactions', 'notes')) {
            \Illuminate\Support\Facades\Schema::table('inventory_transactions', function ($table) {
                $table->text('notes')->nullable()->after('reference');
            });
            $output .= "Added 'notes' column.<br>";
        } else {
            $output .= "'notes' column already exists.<br>";
        }

        // 2. Add 'related_transaction_id' column
        if (!\Illuminate\Support\Facades\Schema::hasColumn('inventory_transactions', 'related_transaction_id')) {
            \Illuminate\Support\Facades\Schema::table('inventory_transactions', function ($table) {
                $table->unsignedBigInteger('related_transaction_id')->nullable()->after('id');
                $table->index('related_transaction_id');
            });
            $output .= "Added 'related_transaction_id' column.<br>";
        } else {
            $output .= "'related_transaction_id' column already exists.<br>";
        }

        // 3. Modify 'type' column
        // Check current driver
        $driver = \Illuminate\Support\Facades\DB::connection()->getDriverName();
        $output .= "DB Driver: $driver<br>";

        if ($driver === 'mysql') {
            \Illuminate\Support\Facades\DB::statement("ALTER TABLE inventory_transactions MODIFY COLUMN type VARCHAR(50)");
            $output .= "Modified 'type' column to VARCHAR(50) (MySQL).<br>";
        } else if ($driver === 'sqlite') {
            $output .= "SQLite detected. Columns are typeless/text usually. Skipping ALTER.<br>";
        } else {
            $output .= "Unknown driver. Skipping ALTER.<br>";
        }

    } catch (\Exception $e) {
        $output .= "Error: " . $e->getMessage();
    }

    return $output;
});












Route::middleware([\App\Http\Middleware\WebAuth::class, \App\Http\Middleware\RoleAccess::class])->group(function () {
    Route::get('dashboard', [DashboardWebController::class, 'index'])->name('dashboard.index');
    Route::get('notifications', [NotificationWebController::class, 'index'])->name('notifications.index');
    Route::get('audits', [AuditWebController::class, 'index'])->name('audits.index');
    Route::resource('donors', DonorWebController::class);
    Route::get('donations/export', [DonationWebController::class, 'export'])->name('donations.export');
    Route::resource('donations', DonationWebController::class);
    Route::resource('warehouses', WarehouseWebController::class);
    Route::resource('items', ItemWebController::class);
    Route::get('inventory-transactions/transfer', [InventoryTransactionWebController::class, 'createTransfer'])->name('inventory-transactions.create-transfer');
    Route::post('inventory-transactions/transfer', [InventoryTransactionWebController::class, 'storeTransfer'])->name('inventory-transactions.store-transfer');
    Route::get('inventory-transactions/reconcile', [InventoryTransactionWebController::class, 'createReconcile'])->name('inventory-transactions.create-reconcile');
    Route::post('inventory-transactions/reconcile', [InventoryTransactionWebController::class, 'storeReconcile'])->name('inventory-transactions.store-reconcile');
    Route::resource('inventory-transactions', InventoryTransactionWebController::class);
    Route::get('beneficiaries/export', [BeneficiaryWebController::class, 'export'])->name('beneficiaries.export');
    Route::post('beneficiaries/bulk', [BeneficiaryWebController::class, 'bulkUpdate'])->name('beneficiaries.bulk');
    Route::resource('beneficiaries', BeneficiaryWebController::class);
    Route::resource('accounts', AccountWebController::class);
    Route::resource('journal-entries', JournalEntryWebController::class);
    Route::get('expenses/export', [ExpenseWebController::class, 'export'])->name('expenses.export');
    Route::resource('expenses', ExpenseWebController::class);
    Route::get('finance/closures', [FinancialClosureWebController::class, 'index'])->name('closures.index');
    Route::get('finance/closures/create', [FinancialClosureWebController::class, 'create'])->name('closures.create');
    Route::post('finance/closures', [FinancialClosureWebController::class, 'store'])->name('closures.store');
    Route::post('finance/closures/{closure}/approve', [FinancialClosureWebController::class, 'approve'])->name('closures.approve');
    Route::post('attachments', [AttachmentWebController::class, 'store'])->name('attachments.store');
    Route::delete('attachments/{attachment}', [AttachmentWebController::class, 'destroy'])->name('attachments.destroy');
    Route::get('delegates/export', [DelegateWebController::class, 'export'])->name('delegates.export');
    Route::post('delegates/bulk', [DelegateWebController::class, 'bulkUpdate'])->name('delegates.bulk');
    Route::post('delegates/{delegate}/trips', [DelegateWebController::class, 'storeTrip'])->name('delegates.storeTrip');
    Route::delete('delegates/{delegate}/trips/{trip}', [DelegateWebController::class, 'destroyTrip'])->name('delegates.destroyTrip');
    Route::patch('delegates/{delegate}/trips/{trip}', [DelegateWebController::class, 'updateTripStatus'])->name('delegates.updateTripStatus');
    Route::resource('delegates', DelegateWebController::class);
    Route::post('travel-routes/{travel_route}/cities', [TravelRouteWebController::class, 'addCity'])->name('travel-routes.addCity');
    Route::post('travel-routes/{travel_route}/trips', [TravelRouteWebController::class, 'addTrip'])->name('travel-routes.addTrip');
    Route::get('travel-routes/export', [TravelRouteWebController::class, 'export'])->name('travel-routes.export');
    Route::post('travel-routes/{travel_route}/duplicate', [TravelRouteWebController::class, 'duplicate'])->name('travel-routes.duplicate');
    Route::resource('travel-routes', TravelRouteWebController::class);
    Route::get('trips', [TripWebController::class, 'index'])->name('trips.index');
    Route::post('trips', [TripWebController::class, 'store'])->name('trips.store');
    Route::get('reports', [ReportsWebController::class, 'index'])->name('reports.index');
    Route::resource('users', UserWebController::class);
    Route::resource('roles', RoleWebController::class);
    Route::post('users/{user}/roles/{role}', [UserWebController::class, 'attachRole'])->name('users.attachRole');
    Route::delete('users/{user}/roles/{role}', [UserWebController::class, 'detachRole'])->name('users.detachRole');
    Route::resource('complaints', ComplaintWebController::class);
    Route::resource('volunteer-hours', VolunteerHourWebController::class);
    Route::resource('payrolls', PayrollWebController::class);
    Route::get('hr/evaluations', [HrEvaluationWebController::class, 'index'])->name('hr.evaluations');
    Route::resource('volunteer-attendance', VolunteerAttendanceWebController::class);
    Route::resource('employee-attendance', EmployeeAttendanceWebController::class);
    Route::resource('tasks', TaskWebController::class);
    Route::resource('volunteer-tasks', VolunteerTaskWebController::class);
    Route::resource('employee-tasks', EmployeeTaskWebController::class);
    Route::resource('volunteers', VolunteerWebController::class);
    Route::get('volunteers/reports', [VolunteerWebController::class, 'reports'])->name('volunteers.reports');
    Route::resource('projects', ProjectWebController::class);
    Route::post('projects/{project}/manager', [ProjectWebController::class, 'setManager'])->name('projects.setManager');
    Route::post('projects/{project}/deputy', [ProjectWebController::class, 'setDeputy'])->name('projects.setDeputy');
    Route::post('projects/{project}/volunteers', [ProjectWebController::class, 'attachVolunteer'])->name('projects.attachVolunteer');
    Route::delete('projects/{project}/volunteers/{user}', [ProjectWebController::class, 'detachVolunteer'])->name('projects.detachVolunteer');
    Route::post('projects/{project}/monthly-volunteers', [ProjectWebController::class, 'storeMonthlyVolunteer'])->name('projects.storeMonthlyVolunteer');
    Route::delete('projects/{project}/monthly-volunteers/{monthlyVolunteer}', [ProjectWebController::class, 'destroyMonthlyVolunteer'])->name('projects.destroyMonthlyVolunteer');
    Route::post('projects/{project}/activities', [ProjectWebController::class, 'storeActivity'])->name('projects.storeActivity');
    Route::delete('projects/{project}/activities/{activity}', [ProjectWebController::class, 'destroyActivity'])->name('projects.destroyActivity');
    Route::resource('campaigns', CampaignWebController::class);
    Route::post('campaigns/{campaign}/manager', [CampaignWebController::class, 'setManager'])->name('campaigns.setManager');
    Route::post('campaigns/{campaign}/volunteers', [CampaignWebController::class, 'attachVolunteer'])->name('campaigns.attachVolunteer');
    Route::delete('campaigns/{campaign}/volunteers/{user}', [CampaignWebController::class, 'detachVolunteer'])->name('campaigns.detachVolunteer');
    Route::post('campaigns/{campaign}/daily-menus', [CampaignWebController::class, 'storeDailyMenu'])->name('campaigns.storeDailyMenu');
    Route::delete('campaigns/{campaign}/daily-menus/{dailyMenu}', [CampaignWebController::class, 'destroyDailyMenu'])->name('campaigns.destroyDailyMenu');
    Route::post('campaigns/{campaign}/monthly-volunteers', [CampaignWebController::class, 'storeMonthlyVolunteer'])->name('campaigns.storeMonthlyVolunteer');
    Route::delete('campaigns/{campaign}/monthly-volunteers/{monthlyVolunteer}', [CampaignWebController::class, 'destroyMonthlyVolunteer'])->name('campaigns.destroyMonthlyVolunteer');
    Route::resource('workspaces', \App\Http\Controllers\WorkspaceWebController::class);
    Route::post('workspaces/{workspace}/rentals', [\App\Http\Controllers\WorkspaceWebController::class, 'storeRental'])->name('workspaces.storeRental');
    Route::patch('workspaces/{workspace}/rentals/{rental}/status', [\App\Http\Controllers\WorkspaceWebController::class, 'updateRentalStatus'])->name('workspaces.updateRentalStatus');
    Route::delete('workspaces/{workspace}/rentals/{rental}', [\App\Http\Controllers\WorkspaceWebController::class, 'destroyRental'])->name('workspaces.destroyRental');
    Route::resource('guest-houses', GuestHouseWebController::class);
    Route::post('guest-houses/{guest_house}/manager', [GuestHouseWebController::class, 'setManager'])->name('guest-houses.setManager');
    Route::post('guest-houses/{guest_house}/volunteers', [GuestHouseWebController::class, 'attachVolunteer'])->name('guest-houses.attachVolunteer');
    Route::delete('guest-houses/{guest_house}/volunteers/{user}', [GuestHouseWebController::class, 'detachVolunteer'])->name('guest-houses.detachVolunteer');
    Route::post('guest-houses/{guest_house}/monthly-volunteers', [GuestHouseWebController::class, 'storeMonthlyVolunteer'])->name('guest-houses.storeMonthlyVolunteer');
    Route::delete('guest-houses/{guest_house}/monthly-volunteers/{monthlyVolunteer}', [GuestHouseWebController::class, 'destroyMonthlyVolunteer'])->name('guest-houses.destroyMonthlyVolunteer');
});
