<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header & Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-8">
            <h2 class="fw-bold text-dark mb-3">الأصناف</h2>
            <div class="row g-3">
                <div class="col-sm-6 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-3 d-flex align-items-center">
                            <div class="bg-primary-subtle text-primary p-3 rounded-circle me-3">
                                <i class="bi bi-box-seam fs-3"></i>
                            </div>
                            <div>
                                <div class="text-muted small mb-1">إجمالي الأصناف</div>
                                <h4 class="fw-bold mb-0"><?php echo e($stats['total']); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-3 d-flex align-items-center">
                            <div class="bg-success-subtle text-success p-3 rounded-circle me-3">
                                <i class="bi bi-currency-dollar fs-3"></i>
                            </div>
                            <div>
                                <div class="text-muted small mb-1">أصناف مقيمة</div>
                                <h4 class="fw-bold mb-0"><?php echo e($stats['with_value']); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 d-flex flex-column justify-content-center align-items-md-end">
            <a href="<?php echo e(route('items.create')); ?>" class="btn btn-primary px-4 py-2">
                <i class="bi bi-plus-lg me-2"></i> إضافة صنف جديد
            </a>
        </div>
    </div>

    <!-- Filters & Search -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body p-3">
            <form action="<?php echo e(route('items.index')); ?>" method="GET" class="row g-3 align-items-center">
                <div class="col-md-6 col-lg-4">
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-end-0 text-muted">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control border-start-0 ps-0" 
                               placeholder="بحث باسم الصنف أو SKU..." 
                               value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">تصفية</button>
                </div>
                <?php if(request()->has('search')): ?>
                <div class="col-md-2">
                    <a href="<?php echo e(route('items.index')); ?>" class="btn btn-link text-decoration-none text-muted">
                        <i class="bi bi-x-circle me-1"></i> مسح
                    </a>
                </div>
                <?php endif; ?>
            </form>
        </div>
    </div>

    <!-- Items Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="ps-4 py-3">اسم الصنف / SKU</th>
                            <th>الوحدة</th>
                            <th>القيمة التقديرية</th>
                            <th>عدد التحركات</th>
                            <th class="text-end pe-4">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr onclick="window.location='<?php echo e(route('items.show', $item)); ?>'" style="cursor: pointer;">
                                <td class="ps-4">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-body-secondary text-body rounded p-2 me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                            <i class="bi bi-box"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold text-body"><?php echo e($item->name); ?></div>
                                            <?php if($item->sku): ?>
                                                <div class="small text-muted font-monospace"><?php echo e($item->sku); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if($item->unit): ?>
                                        <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3"><?php echo e($item->unit); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted small">—</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($item->estimated_value): ?>
                                        <span class="fw-medium"><?php echo e(number_format($item->estimated_value, 2)); ?></span>
                                        <small class="text-muted ms-1">EGP</small>
                                    <?php else: ?>
                                        <span class="text-muted small">—</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-info-subtle text-info rounded-pill">
                                        <?php echo e($item->transactions_count); ?> حركة
                                    </span>
                                </td>
                                <td class="text-end pe-4">
                                    <div class="btn-group" onclick="event.stopPropagation()">
                                        <a href="<?php echo e(route('items.edit', $item)); ?>" class="btn btn-sm btn-outline-secondary" title="تعديل">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" title="حذف" 
                                                onclick="if(confirm('هل أنت متأكد من حذف هذا الصنف؟')) document.getElementById('delete-item-<?php echo e($item->id); ?>').submit()">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                    <form id="delete-item-<?php echo e($item->id); ?>" action="<?php echo e(route('items.destroy', $item)); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="bi bi-search fs-1 d-block mb-3"></i>
                                        <h5>لا توجد نتائج</h5>
                                        <p class="mb-0">لم يتم العثور على أصناف تطابق بحثك.</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($items->hasPages()): ?>
        <div class="card-footer bg-transparent border-0 py-3">
            <?php echo e($items->withQueryString()->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/items/index.blade.php ENDPATH**/ ?>