<?php $__env->startSection('content'); ?>
<style>
.gh-metric-card {
    background: #fff;
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    height: 100%;
    transition: transform 0.2s;
}
.gh-metric-card:hover {
    transform: translateY(-5px);
}
.gh-metric-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
}
.gh-section-title {
    font-weight: 700;
    margin-bottom: 1rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.gh-list-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}
.gh-list-item:last-child {
    border-bottom: none;
}
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-1 fw-bold"><?php echo e($campaign->name); ?> (<?php echo e($campaign->season_year); ?>)</h4>
        <div class="text-muted">
            <span class="badge <?php echo e($campaign->status==='active'?'bg-success':'bg-secondary'); ?>"><?php echo e($campaign->status==='active'?'نشط':'مؤرشف'); ?></span>
            <?php if($campaign->project): ?>
            <span class="mx-2">•</span>
            <a href="<?php echo e(route('projects.show', $campaign->project)); ?>" class="text-decoration-none text-muted"><i class="bi bi-folder me-1"></i> <?php echo e($campaign->project->name); ?></a>
            <?php endif; ?>
            <span class="mx-2">•</span>
            <span><?php echo e($campaign->start_date?->format('Y-m-d') ?? '—'); ?> إلى <?php echo e($campaign->end_date?->format('Y-m-d') ?? '—'); ?></span>
        </div>
    </div>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('campaigns.edit', $campaign)); ?>" class="btn btn-outline-primary"><i class="bi bi-pencil"></i> تعديل</a>
        <a href="<?php echo e(route('campaigns.index')); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-right"></i> عودة</a>
    </div>
</div>

<!-- Metrics Row -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-success bg-opacity-10 text-success">
                <i class="bi bi-cash-coin"></i>
            </div>
            <div class="text-muted small">اجمالي التبرعات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($donationsTotal)); ?></h3>
            <div class="small text-success mt-1">
                <i class="bi bi-arrow-up"></i> <?php echo e($donationsCount); ?> عملية
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-danger bg-opacity-10 text-danger">
                <i class="bi bi-cart"></i>
            </div>
            <div class="text-muted small">اجمالي المصروفات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($expensesTotal)); ?></h3>
            <div class="small text-danger mt-1">
                <i class="bi bi-arrow-down"></i> <?php echo e($expensesCount); ?> عملية
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-primary bg-opacity-10 text-primary">
                <i class="bi bi-wallet2"></i>
            </div>
            <div class="text-muted small">صافي الحسابات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($netBalance)); ?></h3>
            <div class="small text-muted mt-1">
                الرصيد الحالي
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-info bg-opacity-10 text-info">
                <i class="bi bi-people"></i>
            </div>
            <div class="text-muted small">المستفيدون</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($beneficiariesCount)); ?></h3>
            <div class="small text-muted mt-1">
                مستفيد مسجل
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Left Column: Main Lists -->
    <div class="col-lg-8">
        
        <!-- Daily Menu (Ramadan) -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-calendar-check text-success me-2"></i> قائمة الإطعام اليومية</span>
                    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#dailyMenuModal"><i class="bi bi-plus"></i> إضافة</button>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>التاريخ</th>
                                <th>المسؤول</th>
                                <th>الوجبة/النوع</th>
                                <th>العدد</th>
                                <th>المكونات</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $dailyMenus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="text-nowrap"><?php echo e($menu->day_date->format('Y-m-d')); ?></td>
                                <td>
                                    <?php if($menu->responsible): ?>
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2" style="width:24px;height:24px;font-size:0.7rem">
                                            <?php echo e(mb_substr($menu->responsible->name, 0, 1)); ?>

                                        </div>
                                        <span class="small"><?php echo e($menu->responsible->name); ?></span>
                                    </div>
                                    <?php else: ?>
                                    <span class="text-muted small">—</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="fw-bold"><?php echo e($menu->menu); ?></div>
                                    <div class="small text-muted"><?php echo e($menu->meal_type); ?></div>
                                </td>
                                <td class="fw-bold text-primary"><?php echo e($menu->meal_count); ?></td>
                                <td class="small text-muted text-truncate" style="max-width: 150px;"><?php echo e($menu->ingredients); ?></td>
                                <td class="text-end">
                                    <form action="<?php echo e(route('campaigns.destroyDailyMenu', [$campaign, $menu])); ?>" method="POST" onsubmit="return confirm('حذف القائمة؟')">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="6" class="text-center text-muted py-3">لا توجد قوائم مسجلة</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Latest Donations -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-heart text-danger me-2"></i> احدث التبرعات</span>
                    <a href="<?php echo e(route('donations.index',['campaign_id'=>$campaign->id])); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>المتبرع</th>
                                <th>المبلغ/القيمة</th>
                                <th>النوع</th>
                                <th>التاريخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($d->donor->name ?? 'فاعل خير'); ?></td>
                                <td class="fw-bold text-success">
                                    <?php echo e(number_format($d->type=='cash' ? $d->amount : $d->estimated_value)); ?>

                                </td>
                                <td>
                                    <?php if($d->type=='cash'): ?> <span class="badge bg-success bg-opacity-10 text-success">نقدي</span>
                                    <?php else: ?> <span class="badge bg-info bg-opacity-10 text-info">عيني</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-muted small"><?php echo e($d->created_at->format('Y-m-d')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="4" class="text-center text-muted py-3">لا توجد تبرعات مسجلة</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Latest Expenses -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-receipt text-warning me-2"></i> اخر المصروفات</span>
                    <a href="<?php echo e(route('expenses.index',['campaign_id'=>$campaign->id])); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>البند</th>
                                <th>المبلغ</th>
                                <th>التاريخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($e->description ?? 'بدون وصف'); ?></td>
                                <td class="fw-bold text-danger"><?php echo e(number_format($e->amount)); ?></td>
                                <td class="text-muted small"><?php echo e($e->created_at->format('Y-m-d')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="3" class="text-center text-muted py-3">لا توجد مصروفات مسجلة</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Latest Beneficiaries -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-person-check text-primary me-2"></i> المستفيدون الجدد</span>
                    <a href="<?php echo e(route('beneficiaries.index',['campaign_id'=>$campaign->id])); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>رقم الهاتف</th>
                                <th>الحالة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestBeneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($b->name); ?></td>
                                <td><?php echo e($b->phone ?? '—'); ?></td>
                                <td><span class="badge bg-secondary"><?php echo e($b->status ?? 'نشط'); ?></span></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="3" class="text-center text-muted py-3">لا يوجد مستفيدون مسجلون</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <!-- Right Column: Manager, Stats, Volunteers -->
    <div class="col-lg-4">
        
        <!-- Manager Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body text-center p-4">
                <div class="gh-section-title justify-content-center">مدير الحملة</div>
                <?php if($campaign->manager): ?>
                    <div class="mb-3">
                        <?php if($campaign->manager_photo_url): ?>
                            <img src="<?php echo e($campaign->manager_photo_url); ?>" class="rounded-circle mb-2" style="width:80px;height:80px;object-fit:cover">
                        <?php else: ?>
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-2" style="width:80px;height:80px;font-size:2rem">
                                <?php echo e(mb_substr($campaign->manager->name, 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <h5 class="fw-bold mb-0"><?php echo e($campaign->manager->name); ?></h5>
                        <div class="text-muted small"><?php echo e($campaign->manager->email); ?></div>
                    </div>
                    <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#managerModal">تغيير المدير</button>
                <?php else: ?>
                    <div class="text-muted mb-3">لم يتم تعيين مدير بعد</div>
                    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#managerModal">تعيين مدير</button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Donation Details (Chart) -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">تفصيل التبرعات</div>
                <div class="d-flex align-items-center mb-2">
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between small mb-1">
                            <span>نقدي (<?php echo e($cashPct); ?>%)</span>
                            <span><?php echo e(number_format($cashSum)); ?></span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($cashPct); ?>%"></div>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between small mb-1">
                            <span>عيني (<?php echo e(100-$cashPct); ?>%)</span>
                            <span><?php echo e(number_format($inKindSum)); ?></span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(100-$cashPct); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Volunteers -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span>متطوعو الشهر</span>
                    <button class="btn btn-sm btn-primary rounded-circle" data-bs-toggle="modal" data-bs-target="#monthlyVolunteerModal"><i class="bi bi-plus"></i></button>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $monthlyVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-bold"><?php echo e($mv->user->name); ?></div>
                            <div class="small text-muted"><?php echo e($mv->month); ?>/<?php echo e($mv->year); ?></div>
                        </div>
                        <form action="<?php echo e(route('campaigns.destroyMonthlyVolunteer', [$campaign, $mv])); ?>" method="POST" onsubmit="return confirm('حذف؟')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-x-circle"></i></button>
                        </form>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center text-muted small py-2">لا يوجد متطوعين لهذا الشهر</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Campaign Volunteers -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="gh-section-title">
                    <span>متطوعو الحملة</span>
                    <button class="btn btn-sm btn-primary rounded-circle" data-bs-toggle="modal" data-bs-target="#volunteerModal"><i class="bi bi-plus"></i></button>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $campaignVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-bold"><?php echo e($v->name); ?></div>
                            <div class="small text-muted"><?php echo e($v->pivot->role ?? 'متطوع'); ?></div>
                        </div>
                        <form action="<?php echo e(route('campaigns.detachVolunteer', [$campaign, $v])); ?>" method="POST" onsubmit="return confirm('إزالة؟')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-trash"></i></button>
                        </form>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center text-muted small py-2">لا يوجد متطوعين مسجلين</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Manager Modal -->
<div class="modal fade" id="managerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('campaigns.setManager', $campaign)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">تعيين مدير الحملة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المدير</label>
                    <select name="manager_user_id" class="form-select">
                        <option value="">اختر مستخدم...</option>
                        <?php $__currentLoopData = \App\Models\User::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($u->id); ?>" <?php if($campaign->manager_user_id == $u->id): echo 'selected'; endif; ?>><?php echo e($u->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">صورة المدير (اختياري)</label>
                    <input type="file" name="manager_photo" class="form-control" accept="image/*">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">حفظ</button>
            </div>
        </form>
    </div>
</div>

<!-- Volunteer Modal -->
<div class="modal fade" id="volunteerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('campaigns.attachVolunteer', $campaign)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">إضافة متطوع للحملة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المتطوع</label>
                    <select name="user_id" class="form-select" required>
                        <option value="">اختر متطوع...</option>
                        <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">الدور</label>
                    <input type="text" name="role" class="form-control" placeholder="مثال: مشرف، مساعد...">
                </div>
                <div class="row g-2 mb-3">
                    <div class="col-6">
                        <label class="form-label">ساعات</label>
                        <input type="number" step="0.5" name="hours" class="form-control" placeholder="0">
                    </div>
                    <div class="col-6">
                        <label class="form-label">تاريخ البدء</label>
                        <input type="date" name="started_at" class="form-control" value="<?php echo e(date('Y-m-d')); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>
</div>

<!-- Daily Menu Modal -->
<div class="modal fade" id="dailyMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('campaigns.storeDailyMenu', $campaign)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">إضافة قائمة إطعام</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row g-2 mb-3">
                    <div class="col-6">
                        <label class="form-label">التاريخ</label>
                        <input type="date" name="day_date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                    </div>
                    <div class="col-6">
                        <label class="form-label">المسؤول</label>
                        <select name="responsible_user_id" class="form-select">
                            <option value="">اختر مسؤول...</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="row g-2 mb-3">
                    <div class="col-6">
                        <label class="form-label">نوع الوجبة</label>
                        <input list="mealTypeOptions" name="meal_type" class="form-control" placeholder="اختر أو اكتب...">
                        <datalist id="mealTypeOptions">
                            <option value="إفطار">
                            <option value="سحور">
                            <option value="عشاء">
                            <option value="بروتين">
                            <option value="نشويات">
                            <option value="خضار">
                        </datalist>
                    </div>
                    <div class="col-6">
                        <label class="form-label">العدد</label>
                        <input type="number" name="meal_count" class="form-control" value="0" min="0">
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">محتوى الوجبة (المنيو)</label>
                    <input type="text" name="menu" class="form-control" placeholder="مثال: أرز ودجاج...">
                </div>
                <div class="mb-3">
                    <label class="form-label">الكميات / المكونات</label>
                    <textarea name="ingredients" class="form-control" rows="3" placeholder="تفاصيل الكميات والمقادير..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>
</div>

<!-- Monthly Volunteer Modal -->
<div class="modal fade" id="monthlyVolunteerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('campaigns.storeMonthlyVolunteer', $campaign)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">إضافة متطوع للشهر</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المتطوع</label>
                    <select name="user_id" class="form-select" required>
                        <option value="">اختر متطوع...</option>
                        <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="row g-2">
                    <div class="col-6 mb-3">
                        <label class="form-label">الشهر</label>
                        <select name="month" class="form-select">
                            <?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m); ?>" <?php if($m == date('n')): echo 'selected'; endif; ?>><?php echo e($m); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label">السنة</label>
                        <select name="year" class="form-select">
                            <?php $__currentLoopData = range(date('Y')-1, date('Y')+1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($y); ?>" <?php if($y == date('Y')): echo 'selected'; endif; ?>><?php echo e($y); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">ملاحظات</label>
                    <textarea name="notes" class="form-control" rows="2"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/campaigns/show.blade.php ENDPATH**/ ?>