<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('items.index')); ?>" class="text-decoration-none">الأصناف</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($item->name); ?></li>
                </ol>
            </nav>
            <h2 class="fw-bold text-dark mb-0"><?php echo e($item->name); ?></h2>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('items.edit', $item)); ?>" class="btn btn-primary">
                <i class="bi bi-pencil me-1"></i> تعديل
            </a>
            <form action="<?php echo e(route('items.destroy', $item)); ?>" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا الصنف؟');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-outline-danger">
                    <i class="bi bi-trash me-1"></i> حذف
                </button>
            </form>
        </div>
    </div>

    <div class="row g-4">
        <!-- Item Info -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body p-4">
                    <h5 class="card-title fw-bold mb-4">بيانات الصنف</h5>
                    
                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-secondary-subtle rounded-circle p-2 me-3 text-secondary">
                            <i class="bi bi-upc-scan fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">SKU</div>
                            <div class="fw-medium font-monospace"><?php echo e($item->sku ?? '—'); ?></div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-secondary-subtle rounded-circle p-2 me-3 text-secondary">
                            <i class="bi bi-rulers fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">الوحدة</div>
                            <div class="fw-medium"><?php echo e($item->unit ?? '—'); ?></div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-success-subtle rounded-circle p-2 me-3 text-success">
                            <i class="bi bi-currency-dollar fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">القيمة التقديرية</div>
                            <div class="fw-medium">
                                <?php if($item->estimated_value): ?>
                                    <?php echo e(number_format($item->estimated_value, 2)); ?> EGP
                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center">
                        <div class="bg-primary-subtle rounded-circle p-2 me-3 text-primary">
                            <i class="bi bi-layers fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">إجمالي المخزون</div>
                            <div class="fw-bold fs-5"><?php echo e($stock_by_warehouse->sum('current_stock')); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock Distribution -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-0 pt-4 px-4 pb-2">
                    <h5 class="card-title fw-bold mb-0">توزيع المخزون</h5>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php $__empty_1 = true; $__currentLoopData = $stock_by_warehouse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="list-group-item px-4 py-3 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <div class="bg-primary-subtle text-primary rounded-circle p-1 me-3 d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                        <i class="bi bi-building small"></i>
                                    </div>
                                    <a href="<?php echo e(route('warehouses.show', $stock->warehouse_id)); ?>" class="text-decoration-none text-dark fw-medium">
                                        <?php echo e($stock->warehouse->name); ?>

                                    </a>
                                </div>
                                <span class="badge bg-primary rounded-pill"><?php echo e($stock->current_stock); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center py-4 text-muted">
                                <i class="bi bi-box2 fs-1 d-block mb-2"></i>
                                لا يوجد مخزون حالياً
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- History -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 pt-4 px-4 pb-2">
                    <h5 class="card-title fw-bold mb-0">سجل التحركات</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th class="ps-4">التاريخ</th>
                                    <th>النوع</th>
                                    <th>المخزن</th>
                                    <th>الكمية</th>
                                    <th>المرجع</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recent_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="ps-4 text-muted small"><?php echo e($transaction->created_at->format('Y-m-d H:i')); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($transaction->type === 'in' ? 'success' : 'danger'); ?>-subtle text-<?php echo e($transaction->type === 'in' ? 'success' : 'danger'); ?> rounded-pill">
                                                <?php echo e($transaction->type === 'in' ? 'وارد' : 'صادر'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php if($transaction->warehouse): ?>
                                                <a href="<?php echo e(route('warehouses.show', $transaction->warehouse_id)); ?>" class="text-decoration-none">
                                                    <?php echo e($transaction->warehouse->name); ?>

                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted small">مخزن محذوف</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="fw-bold"><?php echo e($transaction->quantity); ?></td>
                                        <td class="text-muted small">
                                            <?php if($transaction->reference): ?>
                                                #<?php echo e($transaction->reference); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-5">
                                            <div class="text-muted">
                                                <i class="bi bi-clock-history fs-1 d-block mb-3"></i>
                                                <p class="mb-0">لا توجد تحركات سابقة لهذا الصنف.</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/items/show.blade.php ENDPATH**/ ?>