<?php $__env->startSection('content'); ?>
  <div class="card p-4">
    <h5 class="mb-3">إضافة تبرع</h5>

    <form method="POST" action="<?php echo e(route('donations.store')); ?>" id="donationForm">
      <?php echo csrf_field(); ?>
      <div class="row g-3">

        <div class="col-md-12 mt-2" id="newDonorFields">
          <div class="row g-2">
            <div class="col-md-6">
              <label class="form-label">الاسم</label>
              <input type="text" name="new_donor_name" class="form-control <?php $__errorArgs = ['new_donor_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                value="<?php echo e(old('new_donor_name')); ?>" placeholder="اكتب اسم المتبرع">
              <?php $__errorArgs = ['new_donor_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-6">
              <label class="form-label">الهاتف</label>
              <input type="tel" pattern="^(01[0125][0-9]{8})$" title="رقم هاتف مصري يبدأ بـ 010, 011, 012, 015"
                inputmode="numeric" name="new_donor_phone"
                class="form-control <?php $__errorArgs = ['new_donor_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('new_donor_phone')); ?>"
                placeholder="رقم الهاتف" required>
              <?php $__errorArgs = ['new_donor_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-12">
              <label class="form-label">العنوان</label>
              <input type="text" name="new_donor_address"
                class="form-control <?php $__errorArgs = ['new_donor_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                value="<?php echo e(old('new_donor_address')); ?>" placeholder="العنوان" required>
              <?php $__errorArgs = ['new_donor_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-6">
              <label class="form-label">تصنيف</label>
              <select name="new_donor_classification" class="form-select">
                <option value="">—</option>
                <option value="one_time" <?php if(old('new_donor_classification') == 'one_time'): echo 'selected'; endif; ?>>مرة واحدة</option>
                <option value="recurring" <?php if(old('new_donor_classification') == 'recurring'): echo 'selected'; endif; ?>>متكرر</option>
              </select>
            </div>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">النوع</label>
          <select name="type" class="form-select" required id="donationType">
            <option value="cash">نقدي</option>
            <option value="in_kind">عيني</option>
          </select>
        </div>
        <div class="col-md-6 cash-only">
          <label class="form-label">المبلغ</label>
          <div class="input-group">
            <input name="amount" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control">
            <select name="currency" class="form-select" style="max-width:140px">
              <option value="EGP" selected>EGP</option>
              <option value="USD">USD</option>
              <option value="EUR">EUR</option>
              <option value="SAR">SAR</option>
              <option value="GBP">GBP</option>
            </select>
          </div>
        </div>
        <div class="col-md-6 cash-only">
          <label class="form-label">طريقة الدفع</label>
          <select name="cash_channel" id="cashChannelSel" class="form-select">
            <option value="cash">نقدي</option>
            <option value="instapay">انستا باي</option>
            <option value="vodafone_cash">فودافون كاش</option>
            <option value="delegate">مندوب</option>
          </select>
        </div>
        <div class="col-md-6 cash-only">
          <label class="form-label">رقم الإيصال</label>
          <input name="receipt_number" class="form-control <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
            value="<?php echo e(old('receipt_number')); ?>" placeholder="مثال: RC-2025-000123">
          <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-md-6 in-kind-only">
          <label class="form-label">القيمة التقديرية</label>
          <div class="input-group">
            <input name="estimated_value" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control">
            <select name="currency" class="form-select" style="max-width:140px">
              <option value="EGP" selected>EGP</option>
              <option value="USD">USD</option>
              <option value="EUR">EUR</option>
              <option value="SAR">SAR</option>
              <option value="GBP">GBP</option>
            </select>
          </div>
        </div>
        <div class="col-md-6 in-kind-only">
          <label class="form-label">المخزن</label>
          <select name="warehouse_id" class="form-select">
            <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($w->id); ?>"><?php echo e($w->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">التبرع لـ</label>
          <select id="allocType" name="allocation_type" class="form-select">
            <option value="">—</option>
            <option value="project" <?php if(old('allocation_type') == 'project'): echo 'selected'; endif; ?>>مشروع</option>
            <option value="guest_house" <?php if(old('allocation_type') == 'guest_house'): echo 'selected'; endif; ?>>دار الضيافة</option>
            <option value="campaign" <?php if(old('allocation_type') == 'campaign'): echo 'selected'; endif; ?>>حملة</option>
            <option value="sponsorship" <?php if(old('allocation_type') == 'sponsorship'): echo 'selected'; endif; ?>>كفالة</option>
            <option value="sadaqa_jariya" <?php if(old('allocation_type') == 'sadaqa_jariya'): echo 'selected'; endif; ?>>صدقة جارية</option>
          </select>
        </div>
        <div class="col-md-6 alloc alloc-project" style="display:none">
          <label class="form-label">المشروع</label>
          <select name="project_id" class="form-select" id="projectSel" disabled>
            <option value="">—</option>
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($p->id); ?>" <?php if(old('project_id', request('project_id')) == $p->id): echo 'selected'; endif; ?>><?php echo e($p->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-12" id="sponsorInfo" style="display:none">
          <div class="alert alert-info d-flex justify-content-between align-items-center">
            <div>
              <div>الكافل: <span id="sponsorName"></span></div>
              <div>يكفل الطفل: <span id="sponsorChild"></span></div>
              <div>المبلغ الشهري: <span id="sponsorAmount"></span></div>
            </div>
            <div class="small">المشروع: <span id="sponsorProject"></span></div>
          </div>
        </div>
        <div class="col-md-6 alloc alloc-campaign" style="display:none">
          <label class="form-label">الحملة</label>
          <select name="campaign_id" class="form-select" disabled>
            <option value="">—</option>
            <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($c->id); ?>" <?php if(old('campaign_id', request('campaign_id')) == $c->id): echo 'selected'; endif; ?>><?php echo e($c->name); ?>

                (<?php echo e($c->season_year); ?>)</option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-md-6 alloc alloc-guest_house" style="display:none">
          <label class="form-label">دار الضيافة</label>
          <select name="guest_house_id" class="form-select" disabled>
            <option value="">—</option>
            <?php $__currentLoopData = $guestHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($gh->id); ?>" <?php if(old('guest_house_id', request('guest_house_id')) == $gh->id): echo 'selected'; endif; ?>>
                <?php echo e($gh->name); ?><?php echo e($gh->location ? (' - ' . $gh->location) : ''); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-md-6 alloc alloc-sponsorship" style="display:none">
          <label class="form-label">نوع الكفالة</label>
          <select id="sponsorshipKind" name="sponsorship_type" class="form-select" disabled>
            <option value="طفل" <?php if(old('sponsorship_type') == 'طفل'): echo 'selected'; endif; ?>>طفل</option>
            <option value="أسرة" <?php if(old('sponsorship_type') == 'أسرة'): echo 'selected'; endif; ?>>أسرة</option>
          </select>
        </div>
        <div class="col-md-6 alloc alloc-sponsorship" id="sponsorshipBeneficiaryBox" style="display:none">
          <label class="form-label">اسم الطفل/الأسرة المكفولة</label>
          <select id="sponsorshipBeneficiary" name="beneficiary_id" class="form-select" disabled>
            <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($b->id); ?>" <?php if(old('beneficiary_id') == $b->id): echo 'selected'; endif; ?>><?php echo e($b->full_name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-md-6 route-only" style="display:none">
          <label class="form-label">خط السير</label>
          <select name="route_id" class="form-select" id="routeSel" disabled>
            <option value="">—</option>
            <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="col-12">
          <label class="form-label">ملاحظة تخصيص</label>
          <textarea name="allocation_note" class="form-control" rows="2"></textarea>
        </div>
        <div class="col-md-6">
          <label class="form-label">تاريخ الاستلام</label>
          <input name="received_at" type="date" class="form-control" value="<?php echo e(now()->format('Y-m-d')); ?>">
        </div>
      </div>
      <div class="mt-3">
        <button class="btn btn-primary">حفظ</button>
        <a href="<?php echo e(route('donations.index')); ?>" class="btn btn-light">رجوع</a>
      </div>
    </form>
  </div>
  <script>
    const beneficiariesMap = {
      <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        "<?php echo e($b->id); ?>": "<?php echo e($b->full_name); ?>",
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    };

    const t = document.getElementById('donationType');
    const cashChannel = document.getElementById('cashChannelSel');
    const routeWrap = document.querySelector('.route-only');
    const routeSel = document.getElementById('routeSel');

    function toggle() {
      const cash = document.querySelectorAll('.cash-only');
      const kind = document.querySelectorAll('.in-kind-only');
      const isCash = t && t.value === 'cash';

      cash.forEach(e => e.style.display = isCash ? 'block' : 'none');
      kind.forEach(e => e.style.display = isCash ? 'none' : 'block');

      const cashCur = document.querySelector('.cash-only select[name="currency"]');
      const kindCur = document.querySelector('.in-kind-only select[name="currency"]');
      if (cashCur) cashCur.disabled = !isCash;
      if (kindCur) kindCur.disabled = isCash;

      const showRoute = isCash && cashChannel && cashChannel.value === 'delegate';
      if (routeWrap) { routeWrap.style.display = showRoute ? 'block' : 'none'; }
      if (routeSel) { routeSel.disabled = !showRoute; if (!showRoute) { routeSel.value = ''; } }
    }

    if (t) {
      t.addEventListener('change', toggle);
      toggle(); // Initial run
    }
    if (cashChannel) { cashChannel.addEventListener('change', toggle); }

    const allocType = document.getElementById('allocType');
    function allocToggle() {
      var v = allocType ? allocType.value : '';

      // Hide all alloc sections first
      document.querySelectorAll('.alloc').forEach(function (e) { e.style.display = 'none'; });

      // Determine which inputs should be enabled
      var enabledInputs = [];
      if (v === 'project') enabledInputs.push('project_id');
      else if (v === 'campaign') enabledInputs.push('campaign_id');
      else if (v === 'guest_house') enabledInputs.push('guest_house_id');
      else if (v === 'sponsorship') { enabledInputs.push('sponsorship_type'); enabledInputs.push('beneficiary_id'); }
      else if (v === 'sadaqa_jariya') enabledInputs.push('project_id');

      // Manage states of all relevant inputs
      ['project_id', 'guest_house_id', 'campaign_id', 'sponsorship_type', 'beneficiary_id'].forEach(function (n) {
        var el = document.querySelector('[name="' + n + '"]');
        if (!el) return;

        if (enabledInputs.includes(n)) {
          el.disabled = false;
          // Add required except for project in sadaqa_jariya
          if (n !== 'project_id' || v !== 'sadaqa_jariya') {
            el.setAttribute('required', 'required');
          } else {
            el.removeAttribute('required');
          }
        } else {
          el.disabled = true;
          el.removeAttribute('required');
          if (n !== 'sponsorship_type') el.value = ''; // Clear only if disabling
        }
      });

      // Show the relevant section container
      if (v) {
        if (v === 'sponsorship') {
          document.querySelectorAll('.alloc.alloc-sponsorship').forEach(function (e) { e.style.display = 'block'; });
        } else if (v === 'sadaqa_jariya') {
          var boxP = document.querySelector('.alloc.alloc-project'); if (boxP) boxP.style.display = 'block';
        } else {
          var box = document.querySelector('.alloc.alloc-' + v); if (box) box.style.display = 'block';
        }
      }

      updateSponsor();
      updateAllocationNote();
    }
    if (allocType) { allocType.addEventListener('change', allocToggle); }
    allocToggle();



    var allocationNoteText = document.querySelector('textarea[name="allocation_note"]');
    function updateAllocationNote() {
      if (!allocationNoteText) return;
      var v = allocType ? allocType.value : '';
      if (v === 'sponsorship') {
        var kind = (document.getElementById('sponsorshipKind') || { value: '' }).value;
        var ben = (document.getElementById('sponsorshipBeneficiary') || { value: '' }).value;
        allocationNoteText.value = 'sponsorship=' + kind + (ben ? (';beneficiary_id=' + ben) : '');
      } else if (v === 'sadaqa_jariya') {
        allocationNoteText.value = 'sponsorship=sadaqa_jariya';
      }
    }
    var sk = document.getElementById('sponsorshipKind'); if (sk) { sk.addEventListener('change', function () { updateAllocationNote(); }); }
    var sben = document.getElementById('sponsorshipBeneficiary'); if (sben) { sben.addEventListener('change', updateAllocationNote); }



  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donations/create.blade.php ENDPATH**/ ?>