
<?php $__env->startSection('content'); ?>
<style>
.route-card{border:none;border-radius:16px;overflow:hidden;box-shadow:0 10px 24px rgba(13,110,253,.08);background:linear-gradient(135deg,#f8fbff,#eef5ff);cursor:pointer}
.route-card .header{display:flex;align-items:center;gap:.75rem;padding:1rem;background:linear-gradient(90deg, var(--primary), var(--accent));color:#fff}
.route-chip{width:40px;height:40px;border-radius:12px;background:rgba(255,255,255,.2);display:flex;align-items:center;justify-content:center;font-weight:700}
.route-body{padding:1rem}
.route-actions{padding:1rem;border-top:1px solid #e9eef7;display:flex;gap:.5rem;justify-content:flex-end}
.routes-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:16px}
.search-wrap{background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.06);border-radius:12px}
.theme-dark .search-wrap { background: var(--card-bg); color: var(--text); }
.theme-dark .route-card { background: var(--card-bg); color: var(--text); }
</style>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">خطوط السير</h4>
  <div class="d-flex gap-2">
    <a href="<?php echo e(route('travel-routes.export', request()->query())); ?>" class="btn btn-outline-secondary"><i class="bi bi-download"></i> تصدير CSV</a>
    <a href="<?php echo e(route('travel-routes.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة خط</a>
  </div>
</div>
<form method="GET" class="search-wrap p-3 mb-3">
  <div class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">بحث بالاسم</label>
      <input name="q" value="<?php echo e($q ?? ''); ?>" class="form-control" placeholder="القاهرة، الجيزة...">
    </div>
    <div class="col-md-2">
      <label class="form-label">عدد المدن من</label>
      <input name="min_cities" value="<?php echo e($minCities ?? ''); ?>" type="number" min="0" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label">إلى</label>
      <input name="max_cities" value="<?php echo e($maxCities ?? ''); ?>" type="number" min="0" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label">مندوبون</label>
      <select name="has_delegates" class="form-select">
        <option value="">الكل</option>
        <option value="1" <?php if(($hasDelegates ?? '')==='1'): echo 'selected'; endif; ?>>يوجد</option>
        <option value="0" <?php if(($hasDelegates ?? '')==='0'): echo 'selected'; endif; ?>>لا يوجد</option>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">تبرعات</label>
      <select name="has_donations" class="form-select">
        <option value="">الكل</option>
        <option value="1" <?php if(($hasDonations ?? '')==='1'): echo 'selected'; endif; ?>>يوجد</option>
        <option value="0" <?php if(($hasDonations ?? '')==='0'): echo 'selected'; endif; ?>>لا يوجد</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">الترتيب</label>
      <div class="d-flex gap-2">
        <select name="sort" class="form-select">
          <option value="name" <?php if(($sort ?? 'name')==='name'): echo 'selected'; endif; ?>>الاسم</option>
          <option value="cities_count" <?php if(($sort ?? '')==='cities_count'): echo 'selected'; endif; ?>>عدد المدن</option>
          <option value="delegates_count" <?php if(($sort ?? '')==='delegates_count'): echo 'selected'; endif; ?>>عدد المندوبين</option>
          <option value="donations_count" <?php if(($sort ?? '')==='donations_count'): echo 'selected'; endif; ?>>عدد التبرعات</option>
          <option value="donation_total" <?php if(($sort ?? '')==='donation_total'): echo 'selected'; endif; ?>>إجمالي التبرعات</option>
        </select>
        <select name="dir" class="form-select" style="max-width:120px">
          <option value="asc" <?php if(($dir ?? 'asc')==='asc'): echo 'selected'; endif; ?>>تصاعدي</option>
          <option value="desc" <?php if(($dir ?? 'asc')==='desc'): echo 'selected'; endif; ?>>تنازلي</option>
        </select>
      </div>
    </div>
    <div class="col-md-2">
      <label class="form-label">عدد بالصفحة</label>
      <select name="per_page" class="form-select">
        <?php $pp = (int) ($perPage ?? 12); ?>
        <option value="12" <?php if($pp===12): echo 'selected'; endif; ?>>12</option>
        <option value="24" <?php if($pp===24): echo 'selected'; endif; ?>>24</option>
        <option value="48" <?php if($pp===48): echo 'selected'; endif; ?>>48</option>
      </select>
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">تصفية</button>
    </div>
  </div>
</form>
 
<?php
  $sumCities = 0; $sumDelegates = 0; $sumDonations = 0; $sumDonationTotal = 0.0;
  foreach ($routes as $rr) {
    $sumCities += is_array($rr->cities ?? null) ? count($rr->cities) : 0;
    $sumDelegates += (int) ($rr->delegates_count ?? 0);
    $sumDonations += (int) ($rr->donations_count ?? 0);
    $sumDonationTotal += (float) ($rr->donation_total ?? 0);
  }
?>
<div class="row g-3 mb-3">
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">عدد الخطوط (هذه الصفحة)</div>
      <div class="fs-5 fw-bold"><?php echo e(count($routes)); ?></div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي المدن (هذه الصفحة)</div>
      <div class="fs-5 fw-bold"><?php echo e($sumCities); ?></div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي المندوبين (هذه الصفحة)</div>
      <div class="fs-5 fw-bold"><?php echo e($sumDelegates); ?></div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي التبرعات (هذه الصفحة)</div>
      <div class="fs-5 fw-bold"><?php echo e(number_format($sumDonationTotal, 2)); ?></div>
    </div>
  </div>
</div>
<div class="routes-grid">
<?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="route-card" role="button" tabindex="0" onclick="location.href='<?php echo e(route('travel-routes.show',$r)); ?>'" onkeydown="if(event.key==='Enter'){location.href='<?php echo e(route('travel-routes.show',$r)); ?>'}">
    <div class="header">
      <div class="route-chip"><?php echo e($r->name ? mb_substr($r->name,0,1) : '—'); ?></div>
      <div>
        <div class="fw-bold">
          <a href="<?php echo e(route('travel-routes.show',$r)); ?>"
             class="text-body text-decoration-none text-truncate d-inline-block overflow-hidden"
             style="max-width: 180px"
             onclick="event.stopPropagation()"
             title="<?php echo e($r->name); ?>">
            <?php echo e($r->name ?? '—'); ?>

          </a>
        </div>
      </div>
    </div>
    <div class="route-body">
      <?php $citiesCount = is_array($r->cities ?? null) ? count($r->cities) : 0; ?>
      <div class="d-flex flex-wrap gap-2">
        <span class="badge bg-primary-subtle text-primary-emphasis">مدن: <?php echo e($citiesCount); ?></span>
        <span class="badge bg-secondary-subtle text-secondary-emphasis">مندوبون: <?php echo e($r->delegates_count ?? 0); ?></span>
        <span class="badge bg-info-subtle text-info-emphasis">تبرعات: <?php echo e($r->donations_count ?? 0); ?></span>
        <span class="badge bg-success-subtle text-success-emphasis">إجمالي: <?php echo e(number_format((float)($r->donation_total ?? 0), 2)); ?></span>
      </div>
    </div>
    <div class="route-actions" onclick="event.stopPropagation()">
      <a class="btn btn-outline-primary" href="<?php echo e(route('travel-routes.show',$r)); ?>"><i class="bi bi-eye"></i> عرض</a>
      <a class="btn btn-outline-secondary" href="<?php echo e(route('travel-routes.edit',$r)); ?>"><i class="bi bi-pencil"></i> تعديل</a>
      <form class="d-inline" method="POST" action="<?php echo e(route('travel-routes.duplicate',$r)); ?>" onsubmit="return confirm('استنساخ هذا الخط؟');">
        <?php echo csrf_field(); ?>
        <button class="btn btn-outline-dark"><i class="bi bi-files"></i> استنساخ</button>
      </form>
      <form class="d-inline" method="POST" action="<?php echo e(route('travel-routes.destroy',$r)); ?>" onsubmit="return confirm('حذف خط السير؟');">
        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
        <button class="btn btn-outline-danger"><i class="bi bi-trash"></i> حذف</button>
      </form>
    </div>
  </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<div class="mt-3 d-flex justify-content-between align-items-center">
  <div class="text-muted small">الإجمالي: <?php echo e(method_exists($routes,'total') ? $routes->total() : count($routes)); ?></div>
  <?php if(method_exists($routes,'links')): ?>
    <div><?php echo e($routes->links()); ?></div>
  <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/routes/index.blade.php ENDPATH**/ ?>