
<?php $__env->startSection('content'); ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">المصروفات</h4>
    <a href="<?php echo e(route('expenses.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة مصروف</a>
  </div>
  <form method="GET" class="card p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-3">
        <label class="form-label">الشهر</label>
        <select name="month" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($m); ?>" <?php if(request('month') == $m): echo 'selected'; endif; ?>><?php echo e($m); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">السنة</label>
        <select name="year" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = range(date('Y'), 2023); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($y); ?>" <?php if(request('year') == $y): echo 'selected'; endif; ?>><?php echo e($y); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = \App\Models\Project::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($p->id); ?>" <?php if(request('project_id') == $p->id): echo 'selected'; endif; ?>><?php echo e($p->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3 d-flex gap-2">
        <button class="btn btn-primary flex-fill">تصفية</button>
        <a href="<?php echo e(route('expenses.export', request()->query())); ?>" class="btn btn-outline-secondary">تصدير CSV</a>
      </div>
    </div>
  </form>
  <div class="table-responsive">
    <table class="table table-striped">
      <thead>
        <tr>
          <th>#</th>
          <th>النوع</th>
          <th>التصنيف</th>
          <th>المبلغ</th>
          <th>المستفيد</th>
          <th>المشروع</th>
          <th>الحملة</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($e->id); ?></td>
            <td><?php echo e($e->type); ?></td>
            <td><?php echo e($e->category ?? '—'); ?></td>
            <td><?php echo e($e->amount); ?> <?php echo e($e->currency); ?></td>
            <td><?php echo e($e->beneficiary?->full_name ?? '—'); ?></td>
            <td><?php echo e($e->project?->name ?? '—'); ?></td>
            <td><?php echo e($e->campaign?->name ?? '—'); ?></td>
            <td class="text-end"><a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('expenses.show', $e)); ?>">عرض</a><a
                class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('expenses.edit', $e)); ?>">تعديل</a>
              <form class="d-inline" method="POST" action="<?php echo e(route('expenses.destroy', $e)); ?>"><?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?><button class="btn btn-outline-danger btn-sm">حذف</button></form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>
  </div>
  <div class="mt-3"><?php echo e($expenses->links()); ?></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/expenses/index.blade.php ENDPATH**/ ?>