
<?php $__env->startSection('content'); ?>
    <style>
        .gh-metric-card {
            background: #fff;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            height: 100%;
            transition: transform 0.2s;
        }

        .gh-metric-card:hover {
            transform: translateY(-5px);
        }

        .gh-metric-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }

        .gh-section-title {
            font-weight: 700;
            margin-bottom: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .hover-shadow:hover {
            box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15) !important;
            transform: translateY(-2px);
        }

        .transition {
            transition: all 0.3s ease;
        }

        .theme-dark .gh-metric-card {
            background: var(--card-bg);
            color: var(--text);
        }
    </style>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center gap-3">
            <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center"
                style="width:64px;height:64px">
                <i class="bi bi-kanban" style="font-size:1.6rem"></i>
            </div>
            <div>
                <h4 class="mb-1 fw-bold"><?php echo e($project->name); ?></h4>
                <div class="d-flex align-items-center gap-2">
                    <span
                        class="badge <?php echo e($project->status === 'active' ? 'bg-success' : 'bg-secondary'); ?>"><?php echo e($project->status === 'active' ? 'نشط' : 'مؤرشف'); ?></span>
                    <span
                        class="badge <?php echo e($project->fixed ? 'bg-info' : 'bg-secondary-subtle'); ?>"><?php echo e($project->fixed ? 'ثابت' : 'غير ثابت'); ?></span>
                </div>
            </div>
        </div>
        <div class="d-flex gap-2">
            <a class="btn btn-outline-primary" href="<?php echo e(route('projects.edit', $project)); ?>"><i class="bi bi-pencil"></i>
                تعديل</a>
            <a href="<?php echo e(route('projects.index')); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-right"></i>
                عودة</a>
        </div>
    </div>

    <div class="text-muted mb-4"><?php echo e($project->description); ?></div>

    <!-- Metrics Row -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="gh-metric-card">
                <div class="gh-metric-icon bg-success bg-opacity-10 text-success">
                    <i class="bi bi-cash-coin"></i>
                </div>
                <div class="text-muted small">اجمالي التبرعات</div>
                <h3 class="fw-bold mb-0"><?php echo e(number_format($donationsTotal - $activitiesRevenue, 2)); ?></h3>
                <div class="small text-success mt-1">
                    <i class="bi bi-arrow-up"></i> <?php echo e($donationsCount); ?> عملية
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="gh-metric-card">
                <div class="gh-metric-icon bg-warning bg-opacity-10 text-warning">
                    <i class="bi bi-graph-up-arrow"></i>
                </div>
                <div class="text-muted small">إيرادات الأنشطة</div>
                <h3 class="fw-bold mb-0"><?php echo e(number_format($activitiesRevenue, 2)); ?></h3>
                <div class="small text-warning mt-1">
                    من المعارض والدعاية
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="gh-metric-card">
                <div class="gh-metric-icon bg-danger bg-opacity-10 text-danger">
                    <i class="bi bi-cart"></i>
                </div>
                <div class="text-muted small">اجمالي المصروفات</div>
                <h3 class="fw-bold mb-0"><?php echo e(number_format($expensesTotal, 2)); ?></h3>
                <div class="small text-danger mt-1">
                    <i class="bi bi-arrow-down"></i> <?php echo e($expensesCount); ?> عملية
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="gh-metric-card">
                <div class="gh-metric-icon bg-primary bg-opacity-10 text-primary">
                    <i class="bi bi-wallet2"></i>
                </div>
                <div class="text-muted small">صافي الحسابات</div>
                <h3 class="fw-bold mb-0 <?php echo e($netBalance >= 0 ? 'text-success' : 'text-danger'); ?>">
                    <?php echo e(number_format($netBalance, 2)); ?></h3>
                <div class="small text-muted mt-1">
                    الرصيد الحالي
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="gh-metric-card">
                <div class="gh-metric-icon bg-info bg-opacity-10 text-info">
                    <i class="bi bi-people"></i>
                </div>
                <div class="text-muted small">المستفيدون</div>
                <h3 class="fw-bold mb-0"><?php echo e($beneficiariesCount); ?></h3>
                <div class="small text-muted mt-1">
                    مستفيد مسجل
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Left Column: Main Content -->
        <div class="col-lg-8">

            <!-- Campaigns Section -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span><i class="bi bi-flag text-primary me-2"></i> حملات المشروع</span>
                        <a href="<?php echo e(route('campaigns.create')); ?>" class="btn btn-sm btn-outline-primary">إضافة حملة</a>
                    </div>
                    <?php if($project->campaigns->isEmpty()): ?>
                        <div class="text-muted small text-center py-3">لا توجد حملات مرتبطة بهذا المشروع.</div>
                    <?php else: ?>
                        <div class="row g-3">
                            <?php $__currentLoopData = $project->campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <div class="card h-100 shadow-sm border-0 bg-body-tertiary">
                                        <div class="card-body p-3">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <h6 class="fw-bold mb-0">
                                                    <a href="<?php echo e(route('campaigns.show', $pc)); ?>"
                                                        class="text-decoration-none text-body">
                                                        <?php echo e($pc->name); ?> <span
                                                            class="text-muted small">(<?php echo e($pc->season_year); ?>)</span>
                                                    </a>
                                                </h6>
                                                <span
                                                    class="badge <?php echo e($pc->status == 'active' ? 'bg-success' : 'bg-secondary'); ?>"><?php echo e($pc->status == 'active' ? 'نشط' : 'مؤرشف'); ?></span>
                                            </div>
                                            <div class="small text-muted mb-3">
                                                من <?php echo e($pc->start_date?->format('Y-m-d') ?? '—'); ?> إلى
                                                <?php echo e($pc->end_date?->format('Y-m-d') ?? '—'); ?>

                                            </div>
                                            <div class="d-flex gap-2 justify-content-end border-top pt-2 mt-auto">
                                                <form method="POST" action="<?php echo e(route('campaigns.destroy', $pc)); ?>"
                                                    onsubmit="return confirm('حذف الحملة؟');">
                                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-link text-danger btn-sm p-0">حذف</button>
                                                </form>
                                                <span class="text-muted">|</span>
                                                <a href="<?php echo e(route('campaigns.edit', $pc)); ?>"
                                                    class="btn btn-link text-secondary btn-sm p-0">تعديل</a>
                                                <span class="text-muted">|</span>
                                                <a href="<?php echo e(route('campaigns.show', $pc)); ?>"
                                                    class="btn btn-link text-primary btn-sm p-0">عرض</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Latest Donations -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span><i class="bi bi-heart text-danger me-2"></i> احدث التبرعات</span>
                        <a href="<?php echo e(route('donations.index', ['project_id' => $project->id])); ?>"
                            class="btn btn-sm btn-secondary-subtle">عرض الكل</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th>المتبرع</th>
                                    <th>المبلغ/القيمة</th>
                                    <th>النوع</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $latestDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($d->donor->name ?? 'فاعل خير'); ?></td>
                                        <td class="fw-bold text-success">
                                            <?php echo e(number_format($d->type == 'cash' ? $d->amount : $d->estimated_value)); ?>

                                        </td>
                                        <td>
                                            <?php if($d->type == 'cash'): ?> <span
                                                class="badge bg-success bg-opacity-10 text-success">نقدي</span>
                                            <?php else: ?> <span class="badge bg-info bg-opacity-10 text-info">عيني</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-muted small"><?php echo e($d->created_at->format('Y-m-d')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-3">لا توجد تبرعات مسجلة</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Latest Expenses -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span><i class="bi bi-receipt text-warning me-2"></i> اخر المصروفات</span>
                        <a href="<?php echo e(route('expenses.index', ['project_id' => $project->id])); ?>"
                            class="btn btn-sm btn-secondary-subtle">عرض الكل</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th>البند</th>
                                    <th>المبلغ</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $latestExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($e->description ?? 'بدون وصف'); ?></td>
                                        <td class="fw-bold text-danger"><?php echo e(number_format($e->amount)); ?></td>
                                        <td class="text-muted small"><?php echo e($e->created_at->format('Y-m-d')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center text-muted py-3">لا توجد مصروفات مسجلة</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Latest Beneficiaries -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span><i class="bi bi-person-check text-primary me-2"></i> المستفيدون الجدد</span>
                        <a href="<?php echo e(route('beneficiaries.index', ['project_id' => $project->id])); ?>"
                            class="btn btn-sm btn-secondary-subtle">عرض الكل</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th>الاسم</th>
                                    <th>رقم الهاتف</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $latestBeneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($b->name); ?></td>
                                        <td><?php echo e($b->phone ?? '—'); ?></td>
                                        <td><span class="badge bg-secondary"><?php echo e($b->status ?? 'نشط'); ?></span></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center text-muted py-3">لا يوجد مستفيدون مسجلون</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <?php if($project->name === 'مشروع كسوة'): ?>
                <!-- Weekly Activities Section -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <div class="gh-section-title">
                            <span><i class="bi bi-calendar-week text-info me-2"></i> الأنشطة الأسبوعية</span>
                            <div class="badge bg-success">إيرادات المعارض: <?php echo e(number_format($exhibitionsRevenue, 2)); ?></div>
                        </div>

                        <div class="row g-3 mb-4">
                            <!-- Exhibitions -->
                            <div class="col-md-6">
                                <div class="card h-100 border-0 bg-body-tertiary">
                                    <div class="card-header bg-transparent fw-bold text-center small">المعارض (الجمعة)</div>
                                    <div class="card-body p-2" style="max-height: 200px; overflow-y: auto;">
                                        <?php if($exhibitions->isEmpty()): ?>
                                            <div class="text-center text-muted small">لا توجد معارض</div>
                                        <?php else: ?>
                                            <ul class="list-group list-group-flush small bg-transparent">
                                                <?php $__currentLoopData = $exhibitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li
                                                        class="list-group-item bg-transparent d-flex justify-content-between align-items-center px-0 py-1">
                                                        <div>
                                                            <div class="fw-bold"><?php echo e($activity->activity_date->format('Y-m-d')); ?></div>
                                                            <div class="text-muted" style="font-size: 0.8em">
                                                                <?php echo e($activity->location ?? '—'); ?></div>
                                                            <div class="text-muted" style="font-size: 0.8em">
                                                                <?php echo e($activity->description); ?></div>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-bold text-success"><?php echo e(number_format($activity->revenue, 2)); ?>

                                                            </div>
                                                            <form method="POST"
                                                                action="<?php echo e(route('projects.destroyActivity', ['project' => $project->id, 'activity' => $activity->id])); ?>"
                                                                class="d-inline">
                                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                                <button class="btn btn-link text-danger p-0" style="font-size: 0.7rem"
                                                                    onclick="return confirm('هل أنت متأكد؟')">×</button>
                                                            </form>
                                                        </div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Advertising -->
                            <div class="col-md-6">
                                <div class="card h-100 border-0 bg-body-tertiary">
                                    <div class="card-header bg-transparent fw-bold text-center small">الدعايا الأسبوعية</div>
                                    <div class="card-body p-2" style="max-height: 200px; overflow-y: auto;">
                                        <?php if($advertisingDays->isEmpty()): ?>
                                            <div class="text-center text-muted small">لا توجد بيانات</div>
                                        <?php else: ?>
                                            <ul class="list-group list-group-flush small bg-transparent">
                                                <?php $__currentLoopData = $advertisingDays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li
                                                        class="list-group-item bg-transparent d-flex justify-content-between align-items-center px-0 py-1">
                                                        <div>
                                                            <div class="fw-bold"><?php echo e($activity->activity_date->format('Y-m-d')); ?></div>
                                                            <?php if($activity->location): ?>
                                                                <div class="text-muted" style="font-size: 0.8em"><?php echo e($activity->location); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="text-muted" style="font-size: 0.8em">
                                                                <?php echo e($activity->description); ?></div>
                                                        </div>
                                                        <div class="text-end">
                                                            <?php if($activity->revenue > 0): ?>
                                                                <div class="fw-bold text-success"><?php echo e(number_format($activity->revenue, 2)); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                            <form method="POST"
                                                                action="<?php echo e(route('projects.destroyActivity', ['project' => $project->id, 'activity' => $activity->id])); ?>"
                                                                class="d-inline">
                                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                                <button class="btn btn-link text-danger p-0" style="font-size: 0.7rem"
                                                                    onclick="return confirm('هل أنت متأكد؟')">×</button>
                                                            </form>
                                                        </div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <form method="POST" action="<?php echo e(route('projects.storeActivity', $project)); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row g-2 align-items-end bg-body-tertiary p-3 rounded">
                                <div class="col-md-12 mb-2">
                                    <div class="fw-bold small">إضافة نشاط جديد</div>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small">النوع</label>
                                    <select name="type" class="form-select form-select-sm" id="activityType"
                                        onchange="toggleRevenue()">
                                        <option value="exhibition">معرض</option>
                                        <option value="advertising">دعاية</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small">التاريخ</label>
                                    <input type="date" name="activity_date" class="form-control form-control-sm"
                                        value="<?php echo e(date('Y-m-d')); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small">المكان/الوصف</label>
                                    <input type="text" name="location" class="form-control form-control-sm"
                                        placeholder="المكان">
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small">الإيراد</label>
                                    <input type="number" step="0.01" name="revenue" class="form-control form-control-sm"
                                        placeholder="0">
                                </div>
                                <div class="col-md-2">
                                    <button class="btn btn-primary btn-sm w-100">إضافة</button>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <input type="text" name="description" class="form-control form-control-sm"
                                        placeholder="ملاحظات إضافية">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endif; ?>

        </div>

        <!-- Right Column: Sidebar -->
        <div class="col-lg-4">

            <!-- Manager Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body text-center p-4">
                    <div class="gh-section-title justify-content-center">مدير المشروع</div>
                    <div class="mb-3">
                        <?php if($project->manager_photo_url): ?>
                            <img src="<?php echo e($project->manager_photo_url); ?>" class="rounded-circle mb-2"
                                style="width:80px;height:80px;object-fit:cover">
                        <?php else: ?>
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-2"
                                style="width:80px;height:80px;font-size:2rem">
                                <?php echo e(mb_substr($project->manager?->name ?? '?', 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <h5 class="fw-bold mb-0"><?php echo e($project->manager?->name ?? '—'); ?></h5>
                    </div>
                    <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse"
                        data-bs-target="#managerForm">تغيير المدير</button>
                    <div class="collapse mt-3" id="managerForm">
                        <form method="POST" action="<?php echo e(route('projects.setManager', $project)); ?>"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <select name="manager_user_id" class="form-select form-select-sm mb-2">
                                <option value="">—</option>
                                <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($v->id); ?>" <?php if($project->manager_user_id == $v->id): echo 'selected'; endif; ?>><?php echo e($v->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="file" name="manager_photo" class="form-control form-control-sm mb-2"
                                accept="image/*">
                            <button class="btn btn-sm btn-primary w-100">حفظ</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Deputy Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body text-center p-4">
                    <div class="gh-section-title justify-content-center">نائب المدير</div>
                    <div class="mb-3">
                        <?php if($project->deputy_photo_url): ?>
                            <img src="<?php echo e($project->deputy_photo_url); ?>" class="rounded-circle mb-2"
                                style="width:80px;height:80px;object-fit:cover">
                        <?php else: ?>
                            <div class="rounded-circle bg-info text-white d-flex align-items-center justify-content-center mx-auto mb-2"
                                style="width:80px;height:80px;font-size:2rem">
                                <?php echo e(mb_substr($project->deputy?->name ?? '?', 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <h5 class="fw-bold mb-0"><?php echo e($project->deputy?->name ?? '—'); ?></h5>
                    </div>
                    <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse"
                        data-bs-target="#deputyForm">تغيير النائب</button>
                    <div class="collapse mt-3" id="deputyForm">
                        <form method="POST" action="<?php echo e(route('projects.setDeputy', $project)); ?>"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <select name="deputy_user_id" class="form-select form-select-sm mb-2">
                                <option value="">—</option>
                                <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($v->id); ?>" <?php if($project->deputy_user_id == $v->id): echo 'selected'; endif; ?>><?php echo e($v->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="file" name="deputy_photo" class="form-control form-control-sm mb-2"
                                accept="image/*">
                            <button class="btn btn-sm btn-primary w-100">حفظ</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Donation Details (Chart) -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">تفصيل التبرعات</div>
                    <div class="d-flex align-items-center mb-2">
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between small mb-1">
                                <span>نقدي (<?php echo e($cashPct); ?>%)</span>
                                <span><?php echo e(number_format($cashSum)); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($cashPct); ?>%">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between small mb-1">
                                <span>عيني (<?php echo e(100 - $cashPct); ?>%)</span>
                                <span><?php echo e(number_format($inKindSum)); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(100 - $cashPct); ?>%">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Monthly Volunteers -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span>متطوعو الشهر</span>
                    </div>
                    <div class="list-group list-group-flush mb-3">
                        <?php $__empty_1 = true; $__currentLoopData = $monthlyVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="fw-bold"><?php echo e($mv->user->name); ?></div>
                                    <div class="small text-muted"><?php echo e($mv->month); ?>/<?php echo e($mv->year); ?></div>
                                </div>
                                <form action="<?php echo e(route('projects.destroyMonthlyVolunteer', [$project, $mv])); ?>" method="POST"
                                    onsubmit="return confirm('حذف؟')">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-x-circle"></i></button>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center text-muted small py-2">لا يوجد متطوعين لهذا الشهر</div>
                        <?php endif; ?>
                    </div>

                    <form method="POST" action="<?php echo e(route('projects.storeMonthlyVolunteer', $project)); ?>"
                        class="bg-body-tertiary p-2 rounded">
                        <?php echo csrf_field(); ?>
                        <div class="mb-2">
                            <select name="user_id" class="form-select form-select-sm mb-1" required>
                                <option value="">اختر متطوع...</option>
                                <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row g-1 mb-2">
                            <div class="col-6">
                                <select name="month" class="form-select form-select-sm">
                                    <?php for($m = 1; $m <= 12; $m++): ?>
                                    <option value="<?php echo e($m); ?>" <?php if($m == date('n')): echo 'selected'; endif; ?>><?php echo e($m); ?></option> <?php endfor; ?>
                                </select>
                            </div>
                            <div class="col-6">
                                <input type="number" name="year" class="form-control form-control-sm"
                                    value="<?php echo e(date('Y')); ?>">
                            </div>
                        </div>
                        <input type="text" name="notes" class="form-control form-control-sm mb-2" placeholder="ملاحظات">
                        <button class="btn btn-sm btn-primary w-100">إضافة</button>
                    </form>
                </div>
            </div>

            <!-- Project Volunteers -->
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="gh-section-title">
                        <span>متطوعو المشروع</span>
                        <span class="badge bg-secondary"><?php echo e(count($projectVolunteers)); ?></span>
                    </div>

                    <div class="d-flex flex-column gap-2 mb-3">
                        <?php $__currentLoopData = $projectVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="d-flex align-items-center justify-content-between p-2 border rounded hover-shadow transition">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center"
                                        style="width:32px;height:32px;font-weight:bold;font-size:0.8rem">
                                        <?php echo e(mb_substr($pv->name, 0, 1)); ?>

                                    </div>
                                    <div style="line-height:1.1">
                                        <div class="fw-bold small"><?php echo e($pv->name); ?></div>
                                        <div class="text-muted" style="font-size:0.7rem"><?php echo e($pv->pivot->role ?? 'متطوع'); ?></div>
                                    </div>
                                </div>
                                <form method="POST"
                                    action="<?php echo e(route('projects.detachVolunteer', ['project' => $project->id, 'user' => $pv->id])); ?>">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-link text-danger p-0 btn-sm"><i class="bi bi-trash"></i></button>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <form method="POST" action="<?php echo e(route('projects.attachVolunteer', $project)); ?>"
                        class="bg-body-tertiary p-2 rounded">
                        <?php echo csrf_field(); ?>
                        <div class="mb-2">
                            <select name="user_id" class="form-select form-select-sm mb-1">
                                <option value="">اختر متطوع...</option>
                                <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!$projectVolunteers->contains('id', $v->id)): ?>
                                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="mb-2">
                            <input type="text" name="role" class="form-control form-control-sm" placeholder="الدور">
                        </div>
                        <div class="row g-1 mb-2">
                            <div class="col-6">
                                <input type="number" step="0.5" name="hours" class="form-control form-control-sm"
                                    placeholder="ساعات">
                            </div>
                            <div class="col-6">
                                <input type="date" name="started_at" class="form-control form-control-sm"
                                    value="<?php echo e(date('Y-m-d')); ?>">
                            </div>
                        </div>
                        <button class="btn btn-sm btn-primary w-100">إضافة متطوع</button>
                    </form>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/projects/show.blade.php ENDPATH**/ ?>