<?php $__env->startSection('content'); ?>
<div class="card p-4">
  <h5 class="mb-3">إضافة حركة مخزون</h5>
  <form method="POST" action="<?php echo e(route('inventory-transactions.store')); ?>" id="invForm">
    <?php echo csrf_field(); ?>
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">الصنف</label>
        <select name="item_id" class="form-select" required>
          <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($i->id); ?>"><?php echo e($i->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">المخزن</label>
        <select name="warehouse_id" class="form-select" required>
          <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($w->id); ?>"><?php echo e($w->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">النوع</label>
        <select name="type" class="form-select" required id="invType">
          <option value="in">إدخال</option>
          <option value="transfer">تحويل</option>
          <option value="out">صرف</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">الكمية</label>
        <input name="quantity" class="form-control" required>
      </div>
      <div class="col-md-4 in-only">
        <label class="form-label">مصدر التبرع العيني</label>
        <select name="source_donation_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($d->id); ?>">#<?php echo e($d->id); ?> - <?php echo e($d->donor?->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4 out-only">
        <label class="form-label">المستفيد</label>
        <select name="beneficiary_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($b->id); ?>"><?php echo e($b->full_name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($p->id); ?>"><?php echo e($p->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-12">
        <label class="form-label">مرجع</label>
        <input name="reference" class="form-control">
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary">حفظ</button>
      <a href="<?php echo e(route('inventory-transactions.index')); ?>" class="btn btn-light">رجوع</a>
    </div>
  </form>
</div>
<script>
const t=document.getElementById('invType');
function toggle(){
  document.querySelectorAll('.in-only').forEach(e=>e.style.display=t.value==='in'?'block':'none');
  document.querySelectorAll('.out-only').forEach(e=>e.style.display=t.value==='out'?'block':'none');
}
toggle(); t.addEventListener('change',toggle);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/inventory/create.blade.php ENDPATH**/ ?>