<?php $__env->startSection('content'); ?>
    <div class="container-fluid p-0">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="fw-bold text-body">مهام المتطوعين</h3>
            <?php if(auth()->user() && auth()->user()->roles->contains('key', 'admin')): ?>
                <a href="<?php echo e(route('volunteer-tasks.create')); ?>" class="btn btn-primary px-4 rounded-pill shadow-sm">
                    <i class="bi bi-plus-lg me-1"></i> إضافة مهمة
                </a>
            <?php endif; ?>
        </div>

        <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-transparent">
                            <tr class="text-secondary small text-uppercase">
                                <th class="py-3 px-4">المهمة</th>
                                <th class="py-3 px-4">النشاط التطوعي</th>
                                <th class="py-3 px-4">الانتماء</th>
                                <th class="py-3 px-4">المتطوع</th>
                                <th class="py-3 px-4">المكلِّف</th>
                                <th class="py-3 px-4">تاريخ الاستحقاق</th>
                                <th class="py-3 px-4">الحالة</th>
                                <th class="py-3 px-4">التقييم</th>
                                <th class="py-3 px-4 text-end">إجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="px-4 fw-medium"><?php echo e($t->title); ?></td>
                                    <td class="px-4 text-muted"><?php echo e($t->volunteer_activity_name ?? '—'); ?></td>
                                    <td class="px-4">
                                        <?php if($t->project): ?> <span
                                            class="badge bg-primary-subtle text-primary border border-primary-subtle rounded-pill">مشروع:
                                            <?php echo e(Str::limit($t->project->name, 15)); ?></span>
                                        <?php elseif($t->campaign): ?> <span
                                            class="badge bg-info-subtle text-info border border-info-subtle rounded-pill">حملة:
                                            <?php echo e(Str::limit($t->campaign->name, 15)); ?></span>
                                        <?php elseif($t->guestHouse): ?> <span
                                            class="badge bg-secondary-subtle text-secondary border border-secondary-subtle rounded-pill">دار:
                                            <?php echo e(Str::limit($t->guestHouse->name, 15)); ?></span>
                                        <?php else: ?> <span class="text-muted">—</span> <?php endif; ?>
                                    </td>
                                    <td class="px-4">
                                        <?php if($t->assignee): ?>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-initials bg-success-subtle text-success rounded-circle me-2 d-flex align-items-center justify-content-center"
                                                    style="width: 25px; height: 25px; font-size: 0.8rem;">
                                                    <?php echo e(strtoupper(substr($t->assignee->name, 0, 1))); ?>

                                                </div>
                                                <span><?php echo e($t->assignee->name); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted small">غير معين</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 small text-muted"><?php echo e($t->assigner?->name ?? '—'); ?></td>
                                    <td class="px-4">
                                        <?php if($t->due_date): ?>
                                            <span
                                                class="<?php echo e($t->due_date->isPast() && $t->status != 'done' ? 'text-danger fw-bold' : 'text-muted'); ?>">
                                                <?php echo e($t->due_date->format('Y-m-d')); ?>

                                            </span>
                                        <?php else: ?>
                                            —
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4">
                                        <?php if($t->status == 'pending'): ?> <span
                                            class="badge bg-secondary-subtle text-secondary rounded-pill px-3">معلق</span>
                                        <?php elseif($t->status == 'in_progress'): ?> <span
                                            class="badge bg-warning-subtle text-warning border border-warning-subtle rounded-pill px-3">جاري
                                            العمل</span>
                                        <?php elseif($t->status == 'done'): ?> <span
                                            class="badge bg-success-subtle text-success border border-success-subtle rounded-pill px-3">مكتمل</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4">
                                        <?php if($t->rating): ?>
                                            <span class="text-warning" title="<?php echo e($t->evaluation_notes); ?>">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <i class="bi bi-star<?php echo e($i <= $t->rating ? '-fill' : ''); ?>"></i>
                                                <?php endfor; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small">غير مقيم</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 text-end">
                                        <div class="btn-group">
                                            <a class="btn btn-sm btn-outline-primary"
                                                href="<?php echo e(route('volunteer-tasks.show', $t)); ?>" title="عرض"><i
                                                    class="bi bi-eye"></i></a>
                                            <?php if(auth()->user() && auth()->user()->roles->contains('key', 'admin')): ?>
                                                <a class="btn btn-sm btn-outline-secondary"
                                                    href="<?php echo e(route('volunteer-tasks.edit', $t)); ?>" title="تعديل"><i
                                                        class="bi bi-pencil"></i></a>
                                                <form class="d-inline" method="POST"
                                                    action="<?php echo e(route('volunteer-tasks.destroy', $t)); ?>"
                                                    onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-sm btn-outline-danger" title="حذف"><i
                                                            class="bi bi-trash"></i></button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-5 text-muted">
                                        <i class="bi bi-clipboard-check display-4 mb-3 d-block opacity-50"></i>
                                        لا توجد مهام مسجلة حالياً
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if($tasks->hasPages()): ?>
                <div class="card-footer bg-transparent border-0 py-3">
                    <?php echo e($tasks->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/volunteer_tasks/index.blade.php ENDPATH**/ ?>