

<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="fw-bold text-dark mb-1">سجل حضور المتطوعين</h3>
            <p class="text-muted mb-0">إدارة ومتابعة سجلات الحضور والانصراف للمتطوعين.</p>
        </div>
        <a href="<?php echo e(route('volunteer-attendance.create')); ?>" class="btn btn-primary btn-lg rounded-pill shadow-sm px-4">
            <i class="bi bi-plus-lg me-2"></i>تسجيل حضور
        </a>
    </div>

    <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr class="text-secondary small text-uppercase">
                            <th class="py-3 px-4">المتطوع</th>
                            <th class="py-3 px-4">التاريخ</th>
                            <th class="py-3 px-4">وقت الدخول</th>
                            <th class="py-3 px-4">وقت الخروج</th>
                            <th class="py-3 px-4">ملاحظات</th>
                            <th class="py-3 px-4">التقييم</th>
                            <th class="py-3 px-4 text-end">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-initials bg-primary-subtle text-primary rounded-circle me-2 d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; font-weight: bold;">
                                        <?php echo e(strtoupper(substr($r->user?->name ?? 'U', 0, 1))); ?>

                                    </div>
                                    <span class="fw-medium"><?php echo e($r->user?->name); ?></span>
                                </div>
                            </td>
                            <td class="px-4 text-secondary"><?php echo e($r->date->format('Y-m-d')); ?></td>
                            <td class="px-4">
                                <?php if($r->check_in_at): ?>
                                    <span class="badge bg-success-subtle text-success rounded-pill fw-normal px-3">
                                        <?php echo e(\Carbon\Carbon::parse($r->check_in_at)->format('H:i')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted small">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4">
                                <?php if($r->check_out_at): ?>
                                    <span class="badge bg-secondary-subtle text-secondary rounded-pill fw-normal px-3">
                                        <?php echo e(\Carbon\Carbon::parse($r->check_out_at)->format('H:i')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted small">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 text-secondary small"><?php echo e(Str::limit($r->notes ?? '—', 30)); ?></td>
                            <td class="px-4">
                                <?php if($r->rating): ?>
                                    <span class="text-warning" title="<?php echo e($r->evaluation_notes); ?>">
                                        <?php for($i=1; $i<=5; $i++): ?>
                                            <i class="bi bi-star<?php echo e($i <= $r->rating ? '-fill' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted small">غير مقيم</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 text-end">
                                <div class="dropdown">
                                    <button class="btn btn-light btn-sm rounded-circle" type="button" data-bs-toggle="dropdown">
                                        <i class="bi bi-three-dots-vertical"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end border-0 shadow-sm">
                                        <li><a class="dropdown-item" href="<?php echo e(route('volunteer-attendance.show', $r)); ?>"><i class="bi bi-eye me-2 text-muted"></i>عرض التفاصيل</a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(route('volunteer-attendance.edit', $r)); ?>"><i class="bi bi-pencil me-2 text-muted"></i>تعديل</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li>
                                            <form action="<?php echo e(route('volunteer-attendance.destroy', $r)); ?>" method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="dropdown-item text-danger"><i class="bi bi-trash me-2"></i>حذف السجل</button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5 text-muted">
                                <i class="bi bi-calendar-x display-4 mb-3 d-block opacity-50"></i>
                                لا توجد سجلات حضور حالياً
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($records->hasPages()): ?>
        <div class="card-footer bg-transparent border-0 py-3">
            <?php echo e($records->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/attendance/index.blade.php ENDPATH**/ ?>