<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <div class="row">
        <!-- Sidebar / Profile Summary -->
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm text-center h-100">
                <div class="card-body p-4">
                    <div class="mb-4 position-relative d-inline-block">
                        <?php if($user->profile_photo_path): ?>
                            <img src="<?php echo e(asset('storage/' . $user->profile_photo_path)); ?>" class="rounded-circle img-thumbnail shadow-sm" style="width: 150px; height: 150px; object-fit: cover;" alt="<?php echo e($user->name); ?>">
                        <?php else: ?>
                            <div class="bg-primary-subtle text-primary rounded-circle d-inline-flex align-items-center justify-content-center fw-bold display-4" style="width: 150px; height: 150px;">
                                <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                            </div>
                        <?php endif; ?>
                        
                        <label for="profile_photo_upload" class="position-absolute bottom-0 end-0 bg-primary text-white rounded-circle p-2 shadow-sm border border-white" style="cursor: pointer; width: 40px; height: 40px; display: flex; align-items: center; justify-content: center;" title="تغيير الصورة">
                            <i class="bi bi-camera-fill"></i>
                        </label>
                        <form id="avatar-form" action="<?php echo e(route('users.update', $user)); ?>" method="POST" enctype="multipart/form-data" class="d-none">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="file" id="profile_photo_upload" name="profile_photo" accept="image/*" onchange="if(confirm('هل تريد تغيير الصورة الشخصية؟')) document.getElementById('avatar-form').submit()">
                        </form>
                    </div>
                    <h3 class="fw-bold mb-1"><?php echo e($user->name); ?></h3>
                    <p class="text-muted mb-3"><?php echo e($user->email); ?></p>
                    
                    <div class="mb-4">
                        <?php if($user->active): ?>
                            <span class="badge bg-success-subtle text-success fs-6 px-3 py-2 rounded-pill"><i class="bi bi-check-circle me-1"></i> نشط</span>
                        <?php else: ?>
                            <span class="badge bg-danger-subtle text-danger fs-6 px-3 py-2 rounded-pill"><i class="bi bi-x-circle me-1"></i> غير نشط</span>
                        <?php endif; ?>
                    </div>

                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-primary"><i class="bi bi-pencil-square me-2"></i> تعديل البيانات</a>
                        <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-secondary">رجوع للقائمة</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content / Details -->
        <div class="col-md-8">
            <!-- Job Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-transparent py-3 border-bottom">
                    <h5 class="mb-0 fw-bold text-primary"><i class="bi bi-briefcase me-2"></i> المعلومات الوظيفية</h5>
                </div>
                <div class="card-body p-4">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">المسمى الوظيفي</label>
                            <div class="fw-medium fs-5"><?php echo e($user->job_title ?? '—'); ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">القسم / الإدارة</label>
                            <div class="fw-medium fs-5"><?php echo e($user->department ?? '—'); ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">الراتب</label>
                            <div class="fw-medium fs-5"><?php echo e($user->salary ? number_format($user->salary, 2) . ' ج.م' : '—'); ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">تاريخ الانضمام</label>
                            <div class="fw-medium fs-5"><?php echo e($user->join_date ? \Carbon\Carbon::parse($user->join_date)->format('Y-m-d') : '—'); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Info & Roles -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent py-3 border-bottom">
                    <h5 class="mb-0 fw-bold text-primary"><i class="bi bi-shield-lock me-2"></i> الأدوار والصلاحيات</h5>
                </div>
                <div class="card-body p-4">
                    <div class="row g-4">
                        <div class="col-md-12">
                            <label class="text-muted small mb-1">الأدوار الممنوحة</label>
                            <div class="d-flex flex-wrap gap-2 mt-1">
                                <?php $__empty_1 = true; $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <span class="badge bg-secondary-subtle text-secondary-emphasis fs-6 px-3 py-2">
                                        <?php echo e($role->name); ?>

                                        <?php if($role->description): ?>
                                            <i class="bi bi-info-circle ms-1" data-bs-toggle="tooltip" title="<?php echo e($role->description); ?>"></i>
                                        <?php endif; ?>
                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <span class="text-muted">لا توجد أدوار معينة</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">رقم الهاتف</label>
                            <div class="fw-medium fs-5"><?php echo e($user->phone ?? '—'); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Attendance History -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-transparent py-3 border-bottom d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold text-primary"><i class="bi bi-calendar-check me-2"></i> سجل الحضور</h5>
                    <a href="<?php echo e(route('employee-attendance.index', ['user_id' => $user->id])); ?>" class="btn btn-sm btn-outline-primary rounded-pill">عرض الكل</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th class="px-4 py-3">التاريخ</th>
                                    <th class="px-4 py-3">الدخول</th>
                                    <th class="px-4 py-3">الخروج</th>
                                    <th class="px-4 py-3">التقييم</th>
                                    <th class="px-4 py-3">ملاحظات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $user->employeeAttendances()->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="px-4"><?php echo e($attendance->date->format('Y-m-d')); ?></td>
                                    <td class="px-4">
                                        <?php if($attendance->check_in_at): ?>
                                            <span class="badge bg-success-subtle text-success rounded-pill fw-normal px-2">
                                                <?php echo e(\Carbon\Carbon::parse($attendance->check_in_at)->format('H:i')); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4">
                                        <?php if($attendance->check_out_at): ?>
                                            <span class="badge bg-secondary-subtle text-secondary rounded-pill fw-normal px-2">
                                                <?php echo e(\Carbon\Carbon::parse($attendance->check_out_at)->format('H:i')); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4">
                                        <?php if($attendance->rating): ?>
                                            <span class="text-warning small" title="<?php echo e($attendance->evaluation_notes); ?>">
                                                <?php for($i=1; $i<=5; $i++): ?>
                                                    <i class="bi bi-star<?php echo e($i <= $attendance->rating ? '-fill' : ''); ?>"></i>
                                                <?php endfor; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 small text-muted"><?php echo e(Str::limit($attendance->notes ?? '—', 30)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted">
                                        <i class="bi bi-calendar-x display-6 mb-2 d-block opacity-50"></i>
                                        لا يوجد سجلات حضور حديثة
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Assigned Tasks -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-transparent py-3 border-bottom d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold text-primary"><i class="bi bi-list-check me-2"></i> المهام المسندة</h5>
                    <a href="<?php echo e(route('employee-tasks.index', ['assigned_to' => $user->id])); ?>" class="btn btn-sm btn-outline-primary rounded-pill">عرض الكل</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-transparent">
                                <tr>
                                    <th class="px-4 py-3">المهمة</th>
                                    <th class="px-4 py-3">تاريخ الاستحقاق</th>
                                    <th class="px-4 py-3">الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $user->assignedTasks()->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="px-4 fw-medium"><?php echo e($task->title); ?></td>
                                    <td class="px-4"><?php echo e($task->due_date ? $task->due_date->format('Y-m-d') : '—'); ?></td>
                                    <td class="px-4">
                                        <?php if($task->status == 'completed' || $task->status == 'done'): ?>
                                            <span class="badge bg-success-subtle text-success rounded-pill px-2">منجزة</span>
                                        <?php elseif($task->status == 'in_progress'): ?>
                                            <span class="badge bg-primary-subtle text-primary rounded-pill px-2">قيد التنفيذ</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning-subtle text-warning rounded-pill px-2">قيد الانتظار</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center py-4 text-muted">
                                        <i class="bi bi-clipboard-x display-6 mb-2 d-block opacity-50"></i>
                                        لا توجد مهام مسندة حالياً
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/users/show.blade.php ENDPATH**/ ?>