<?php $__env->startSection('content'); ?>
<div class="card p-4">
  <div class="d-flex justify-content-between align-items-center">
    <h5 class="mb-0">تفاصيل التبرع</h5>
    <a class="btn btn-secondary" href="<?php echo e(route('donations.edit',$donation)); ?>">تعديل</a>
  </div>
  <div class="mt-3">
    <div>المتبرع: <?php echo e($donation->donor?->name ?? '—'); ?></div>
    <div>النوع: <?php echo e($donation->type==='cash'?'نقدي':'عيني'); ?></div>
    <?php if($donation->type==='cash'): ?>
      <div>طريقة الدفع: <?php echo e($donation->cash_channel==='instapay'?'انستا باي':($donation->cash_channel==='vodafone_cash'?'فودافون كاش':'نقدي')); ?></div>
      <div>رقم الإيصال: <?php echo e($donation->receipt_number ?? '—'); ?></div>
      <div>المبلغ: <?php echo e(number_format($donation->amount,2)); ?> <?php echo e($donation->currency); ?></div>
    <?php else: ?>
      <div>القيمة التقديرية: <?php echo e(number_format($donation->estimated_value,2)); ?> <?php echo e($donation->currency); ?></div>
      <div>المخزن: <?php echo e($donation->warehouse?->name ?? '—'); ?></div>
    <?php endif; ?>
    <div>المشروع: <?php echo e($donation->project?->name ?? '—'); ?></div>
    <div>الحملة: <?php echo e($donation->campaign?->name ?? '—'); ?></div>
    <div>تاريخ الاستلام: <?php echo e(optional($donation->received_at)->format('Y-m-d') ?? '—'); ?></div>
    <div>ملاحظة: <?php echo e($donation->allocation_note ?? '—'); ?></div>
  </div>
  <div class="mt-3">
    <a href="<?php echo e(route('donations.index')); ?>" class="btn btn-light">رجوع</a>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donations/show.blade.php ENDPATH**/ ?>