<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>مؤسسة إنسان</title>
  <link rel="icon" href="<?php echo e(asset('logo.png')); ?>" type="image/png">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
  <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">
</head>

<body>
  <nav class="navbar navbar-expand-lg navbar-dark border-bottom">
    <div class="container">
      <a class="navbar-brand" href="/">
        <?php if(file_exists(public_path('logo.png'))): ?>
          <img src="<?php echo e(asset('logo.png')); ?>" alt="إنسان" loading="lazy" decoding="async" onerror="this.remove()">
        <?php endif; ?>

      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav"
        aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="nav">
        <div class="ms-auto d-flex align-items-center gap-3 nav-actions">
          <?php $navUser = request()->user(); ?>
          <?php if($navUser && $navUser->hasPermission('reports.view')): ?>
            <form action="<?php echo e(route('reports.index')); ?>" method="GET" class="d-none d-lg-block">
              <div class="input-group input-group-sm">
                <span class="input-group-text"><i class="bi bi-search"></i></span>
                <input type="text" class="form-control form-control-sm" name="q" placeholder="ابحث...">
              </div>
            </form>
            <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-light btn-sm d-none d-lg-inline-flex"><i
                class="bi bi-graph-up"></i> التقارير</a>
          <?php endif; ?>
          <?php if($navUser && $navUser->hasPermission('notifications.view') && !$navUser->roles->contains('key', 'finance')): ?>
            <button class="btn btn-outline-light btn-sm" type="button" data-bs-toggle="offcanvas"
              data-bs-target="#notifOffcanvas" aria-controls="notifOffcanvas"><i class="bi bi-bell"></i></button>
          <?php endif; ?>
          <button id="themeToggle" class="btn btn-outline-light btn-sm" type="button" aria-label="تبديل الثيم"><i
              class="bi bi-moon"></i></button>
          <?php if($navUser): ?>
            <div class="dropdown">
              <button class="btn btn-light btn-sm dropdown-toggle d-flex align-items-center gap-2"
                data-bs-toggle="dropdown" style="padding: 0.25rem 0.5rem;">
                <?php if($navUser->profile_photo_path): ?>
                  <img src="<?php echo e(asset('storage/' . $navUser->profile_photo_path)); ?>" alt="<?php echo e($navUser->name); ?>"
                    class="rounded-circle border" style="width: 32px; height: 32px; object-fit: cover;">
                <?php else: ?>
                  <div
                    class="bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center fw-bold"
                    style="width: 32px; height: 32px; font-size: 0.85rem;">
                    <?php echo e(strtoupper(substr($navUser->name, 0, 1))); ?>

                  </div>
                <?php endif; ?>
                <span class="d-none d-md-inline fw-bold small"><?php echo e($navUser->name); ?></span>
              </button>
              <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                <li class="px-3 py-2 text-center bg-body-tertiary border-bottom mb-2">
                  <div class="fw-bold text-dark"><?php echo e($navUser->name); ?></div>
                  <div class="small text-muted"><?php echo e($navUser->email); ?></div>
                </li>
                <?php if($navUser->hasPermission('users.view')): ?>
                  <li><a class="dropdown-item" href="<?php echo e(route('users.show', $navUser->id)); ?>"><i
                        class="bi bi-person me-2"></i> الملف الشخصي</a></li>
                <?php endif; ?>
                <li>
                  <hr class="dropdown-divider">
                </li>
                <li>
                  <form method="POST" action="<?php echo e(route('logout')); ?>"><?php echo csrf_field(); ?><button class="dropdown-item text-danger"><i
                        class="bi bi-box-arrow-right me-2"></i> خروج</button></form>
                </li>
              </ul>
            </div>
          <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-light btn-sm">دخول</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </nav>
  <div class="card sidebar-fixed">
    <div class="list-group list-group-flush">
      <?php $user = request()->user(); ?>

      <a href="<?php echo e(route('dashboard.index')); ?>"
        class="list-group-item list-group-item-action <?php echo e(request()->routeIs('dashboard.*') ? 'active' : ''); ?>"><i
          class="bi bi-speedometer2"></i><span>لوحة التحكم</span></a>



      <?php if($user && $user->hasPermission('donors.view')): ?>
        <a href="<?php echo e(route('donors.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('donors.*') ? 'active' : ''); ?>"><i
            class="bi bi-people"></i><span>المتبرعون</span></a>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('donations.view')): ?>
        <a href="<?php echo e(route('donations.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('donations.*') ? 'active' : ''); ?>"><i
            class="bi bi-gift"></i><span>التبرعات</span></a>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('beneficiaries.view')): ?>
        <a href="<?php echo e(route('beneficiaries.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('beneficiaries.*') ? 'active' : ''); ?>"><i
            class="bi bi-person-heart"></i><span>المستفيدون</span></a>
      <?php endif; ?>

      <?php if($user && ($user->hasPermission('delegates.view') || $user->hasPermission('travel_routes.view') || $user->hasPermission('trips.view'))): ?>
        <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
          data-bs-toggle="collapse" href="#delegatesCollapse" role="button"
          aria-expanded="<?php echo e((request()->routeIs('delegates.*') || request()->routeIs('travel-routes.*') || request()->routeIs('trips.*')) ? 'true' : 'false'); ?>"
          aria-controls="delegatesCollapse">
          <span><i class="bi bi-signpost-2"></i> اللوجيستك</span>
          <i class="bi bi-chevron-down sidebar-toggle-icon"></i>
        </a>
        <div
          class="collapse <?php echo e((request()->routeIs('delegates.*') || request()->routeIs('travel-routes.*') || request()->routeIs('trips.*')) ? 'show' : ''); ?> sub-list"
          id="delegatesCollapse">
          <?php if($user->hasPermission('delegates.view')): ?>
            <a href="<?php echo e(route('delegates.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('delegates.*') ? 'active' : ''); ?>"><i
                class="bi bi-person-badge"></i><span>المندوبون</span></a>
          <?php endif; ?>
          <?php if($user->hasPermission('travel_routes.view')): ?>
            <a href="<?php echo e(route('travel-routes.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('travel-routes.*') ? 'active' : ''); ?>"><i
                class="bi bi-geo"></i><span>خطوط السير</span></a>
          <?php endif; ?>
          <?php if($user->hasPermission('trips.view')): ?>
            <a href="<?php echo e(route('trips.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('trips.*') ? 'active' : ''); ?>"><i
                class="bi bi-pin-map"></i><span>الرحلات</span></a>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if($user && ($user->hasPermission('volunteers.view') || $user->hasPermission('users.view') || $user->hasPermission('hr.evaluations') || $user->hasPermission('roles.view'))): ?>
        <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
          data-bs-toggle="collapse" href="#hrCollapse" role="button"
          aria-expanded="<?php echo e((request()->routeIs('volunteers.*') || request()->routeIs('volunteer-attendance.*') || request()->routeIs('employee-attendance.*') || request()->routeIs('volunteer-tasks.*') || request()->routeIs('employee-tasks.*') || request()->routeIs('tasks.*') || request()->routeIs('volunteer-hours.*') || request()->routeIs('payrolls.*') || request()->routeIs('roles.*') || request()->routeIs('hr.evaluations') || request()->routeIs('reports.*') || request()->routeIs('users.*')) ? 'true' : 'false'); ?>"
          aria-controls="hrCollapse">
          <span><i class="bi bi-people"></i> الموارد البشرية HR</span>
          <i class="bi bi-chevron-down sidebar-toggle-icon"></i>
        </a>
        <div
          class="collapse <?php echo e((request()->routeIs('volunteers.*') || request()->routeIs('volunteer-attendance.*') || request()->routeIs('employee-attendance.*') || request()->routeIs('volunteer-tasks.*') || request()->routeIs('employee-tasks.*') || request()->routeIs('tasks.*') || request()->routeIs('volunteer-hours.*') || request()->routeIs('payrolls.*') || request()->routeIs('roles.*') || request()->routeIs('hr.evaluations') || request()->routeIs('reports.*') || request()->routeIs('users.*')) ? 'show' : ''); ?>"
          id="hrCollapse">
          <div class="list-group list-group-flush ps-3">
            <!-- Employees Submenu -->
            <?php if($user->hasPermission('users.view') || $user->hasPermission('employee_attendance.view') || $user->hasPermission('employee_tasks.view')): ?>
              <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
                data-bs-toggle="collapse" href="#empSubCollapse" role="button"
                aria-expanded="<?php echo e((request()->routeIs('users.*') || request()->routeIs('employee-attendance.*') || request()->routeIs('employee-tasks.*')) ? 'true' : 'false'); ?>"
                aria-controls="empSubCollapse">
                <span><i class="bi bi-person-badge"></i> الموظفين والمستخدمين</span>
                <i class="bi bi-chevron-down sidebar-toggle-icon" style="font-size: 0.8em;"></i>
              </a>
              <div
                class="collapse <?php echo e((request()->routeIs('users.*') || request()->routeIs('employee-attendance.*') || request()->routeIs('employee-tasks.*')) ? 'show' : ''); ?>"
                id="empSubCollapse">
                <div class="list-group list-group-flush ps-3 border-start ms-3">
                  <?php if($user->hasPermission('users.view')): ?>
                    <a href="<?php echo e(route('users.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('users.*') ? 'active' : ''); ?>">
                      <i class="bi bi-people"></i> قائمة الموظفين
                    </a>
                  <?php endif; ?>
                  <?php if($user->hasPermission('employee_attendance.view')): ?>
                    <a href="<?php echo e(route('employee-attendance.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('employee-attendance.*') ? 'active' : ''); ?>">
                      <i class="bi bi-calendar-check"></i> حضور الموظفين
                    </a>
                  <?php endif; ?>
                  <?php if($user->hasPermission('employee_tasks.view')): ?>
                    <a href="<?php echo e(route('employee-tasks.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('employee-tasks.*') ? 'active' : ''); ?>">
                      <i class="bi bi-list-check"></i> مهام الموظفين
                    </a>
                  <?php endif; ?>
                </div>
              </div>
            <?php endif; ?>

            <!-- Volunteers Submenu -->
            <?php if($user->hasPermission('volunteers.view') || $user->hasPermission('volunteer_attendance.view') || $user->hasPermission('volunteer_tasks.view') || $user->hasPermission('volunteer_hours.view')): ?>
              <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
                data-bs-toggle="collapse" href="#volSubCollapse" role="button"
                aria-expanded="<?php echo e((request()->routeIs('volunteers.*') || request()->routeIs('volunteer-attendance.*') || request()->routeIs('volunteer-tasks.*') || request()->routeIs('volunteer-hours.*')) ? 'true' : 'false'); ?>"
                aria-controls="volSubCollapse">
                <span><i class="bi bi-person-hearts"></i> المتطوعين</span>
                <i class="bi bi-chevron-down sidebar-toggle-icon" style="font-size: 0.8em;"></i>
              </a>
              <div
                class="collapse <?php echo e((request()->routeIs('volunteers.*') || request()->routeIs('volunteer-attendance.*') || request()->routeIs('volunteer-tasks.*') || request()->routeIs('volunteer-hours.*')) ? 'show' : ''); ?>"
                id="volSubCollapse">
                <div class="list-group list-group-flush ps-3 border-start ms-3">
                  <?php if($user->hasPermission('volunteers.view')): ?>
                    <a href="<?php echo e(route('volunteers.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('volunteers.*') ? 'active' : ''); ?>">
                      <i class="bi bi-person-lines-fill"></i> قائمة المتطوعين
                    </a>
                  <?php endif; ?>
                  <?php if($user->hasPermission('volunteer_attendance.view')): ?>
                    <a href="<?php echo e(route('volunteer-attendance.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('volunteer-attendance.*') ? 'active' : ''); ?>">
                      <i class="bi bi-calendar-event"></i> حضور المتطوعين
                    </a>
                  <?php endif; ?>

                  <?php if($user->hasPermission('volunteer_hours.view')): ?>
                    <a href="<?php echo e(route('volunteer-hours.index')); ?>"
                      class="list-group-item list-group-item-action border-0 <?php echo e(request()->routeIs('volunteer-hours.*') ? 'active' : ''); ?>">
                      <i class="bi bi-clock-history"></i> ساعات التطوع
                    </a>
                  <?php endif; ?>
                </div>
              </div>
            <?php endif; ?>

            <?php if($user->hasPermission('hr.evaluations')): ?>
              <a href="<?php echo e(route('hr.evaluations')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('hr.evaluations') ? 'active' : ''); ?>">
                <i class="bi bi-clipboard-check"></i> التقييمات
              </a>
            <?php endif; ?>

            <?php if($user->hasPermission('roles.view')): ?>
              <a href="<?php echo e(route('roles.index')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('roles.*') ? 'active' : ''); ?>">
                <i class="bi bi-shield-lock"></i> الأدوار والصلاحيات
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>
      <?php $u = request()->user();
      $isAdmin = $u && $u->roles()->where('key', 'admin')->exists(); ?>

      <!-- Accounts Section -->
      <?php if($user && ($user->hasPermission('accounts.view') || $user->hasPermission('journal_entries.view') || $user->hasPermission('expenses.view') || $user->hasPermission('financial_closures.view'))): ?>
        <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
          data-bs-toggle="collapse" href="#accCollapse" role="button"
          aria-expanded="<?php echo e((request()->routeIs('expenses.*') || request()->routeIs('closures.*') || request()->routeIs('accounts.*') || request()->routeIs('journal-entries.*')) ? 'true' : 'false'); ?>"
          aria-controls="accCollapse">
          <span><i class="bi bi-calculator"></i> الحسابات</span>
          <i class="bi bi-chevron-down sidebar-toggle-icon"></i>
        </a>
        <div
          class="collapse <?php echo e((request()->routeIs('expenses.*') || request()->routeIs('closures.*') || request()->routeIs('accounts.*') || request()->routeIs('journal-entries.*')) ? 'show' : ''); ?>"
          id="accCollapse">
          <div class="list-group list-group-flush ps-3">
            <?php if($user->hasPermission('accounts.view')): ?>
              <a href="<?php echo e(route('accounts.index')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('accounts.*') ? 'active' : ''); ?>">
                <i class="bi bi-diagram-3"></i> دليل الحسابات
              </a>
            <?php endif; ?>
            <?php if($user->hasPermission('journal_entries.view')): ?>
              <a href="<?php echo e(route('journal-entries.index')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('journal-entries.*') ? 'active' : ''); ?>">
                <i class="bi bi-journal-text"></i> القيود اليومية
              </a>
            <?php endif; ?>
            <?php if($user->hasPermission('expenses.view')): ?>
              <a href="<?php echo e(route('expenses.index')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('expenses.*') ? 'active' : ''); ?>">
                <i class="bi bi-cash-stack"></i> المصروفات
              </a>
            <?php endif; ?>
            <?php if($user->hasPermission('financial_closures.view')): ?>
              <a href="<?php echo e(route('closures.index')); ?>"
                class="list-group-item list-group-item-action <?php echo e(request()->routeIs('closures.*') ? 'active' : ''); ?>">
                <i class="bi bi-file-earmark-lock"></i> الإقفال المالي
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>

      <?php if($user && ($user->hasPermission('warehouses.view') || $user->hasPermission('items.view') || $user->hasPermission('inventory_transactions.view'))): ?>
        <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
          data-bs-toggle="collapse" href="#invCollapse" role="button"
          aria-expanded="<?php echo e((request()->routeIs('warehouses.*') || request()->routeIs('items.*') || request()->routeIs('inventory-transactions.*')) ? 'true' : 'false'); ?>"
          aria-controls="invCollapse">
          <span><i class="bi bi-building"></i> إدارة المخازن</span>
          <i class="bi bi-chevron-down sidebar-toggle-icon"></i>
        </a>
        <div
          class="collapse <?php echo e((request()->routeIs('warehouses.*') || request()->routeIs('items.*') || request()->routeIs('inventory-transactions.*')) ? 'show' : ''); ?> sub-list"
          id="invCollapse">
          <?php if($user->hasPermission('warehouses.view')): ?>
            <a href="<?php echo e(route('warehouses.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('warehouses.*') ? 'active' : ''); ?>"><i
                class="bi bi-building"></i><span>المخازن</span></a>
          <?php endif; ?>
          <?php if($user->hasPermission('items.view')): ?>
            <a href="<?php echo e(route('items.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('items.*') ? 'active' : ''); ?>"><i
                class="bi bi-box"></i><span>الأصناف</span></a>
          <?php endif; ?>
          <?php if($user->hasPermission('inventory_transactions.view')): ?>
            <a href="<?php echo e(route('inventory-transactions.index')); ?>"
              class="list-group-item list-group-item-action <?php echo e(request()->routeIs('inventory-transactions.*') ? 'active' : ''); ?>"><i
                class="bi bi-arrow-left-right"></i><span>حركات المخزون</span></a>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('projects.view')): ?>
        <a href="<?php echo e(route('projects.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('projects.*') ? 'active' : ''); ?>"><i
            class="bi bi-kanban"></i><span>إدارة المشاريع</span></a>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('campaigns.view')): ?>
        <a href="<?php echo e(route('campaigns.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('campaigns.*') ? 'active' : ''); ?>"><i
            class="bi bi-megaphone"></i><span>إدارة الحملات</span></a>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('guest_houses.view')): ?>
        <a href="<?php echo e(route('guest-houses.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('guest-houses.*') ? 'active' : ''); ?>"><i
            class="bi bi-house"></i><span>إدارة دار الضيافة</span></a>
      <?php endif; ?>

      <?php if($user && $user->hasPermission('workspaces.view')): ?>
        <a href="<?php echo e(route('workspaces.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('workspaces.*') ? 'active' : ''); ?>"><i
            class="bi bi-easel"></i><span>إدارة workspace Ensan</span></a>
      <?php endif; ?>



      <?php if($user && ($user->hasPermission('complaints.view') || $user->hasPermission('complaints.create') || $user->roles->contains('key', 'finance'))): ?>
        <a href="<?php echo e(route('complaints.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('complaints.*') ? 'active' : ''); ?>"><i
            class="bi bi-chat-dots"></i><span>الشكاوى</span></a>
      <?php endif; ?>

      <?php if($user && ($user->hasPermission('volunteer_tasks.view') || $user->roles->contains('key', 'volunteer'))): ?>
        <a href="<?php echo e(route('volunteer-tasks.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('volunteer-tasks.*') ? 'active' : ''); ?>"><i
            class="bi bi-list-task"></i><span>مهام المتطوعين</span></a>
      <?php endif; ?>



      <?php if($user && $user->hasPermission('audits.view')): ?>
        <a href="<?php echo e(route('audits.index')); ?>"
          class="list-group-item list-group-item-action <?php echo e(request()->routeIs('audits.*') ? 'active' : ''); ?>"><i
            class="bi bi-activity"></i><span>السجلات Logs</span></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="container content-wrapper">
    <?php echo $__env->make('partials.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>

    <footer class="mt-5 pt-4 pb-4 text-center text-muted small">
      <div class="container">
        <div class="d-flex justify-content-center align-items-center mb-2">
          <?php if(file_exists(public_path('logo.png'))): ?>
            <img src="<?php echo e(asset('logo.png')); ?>" alt="logo" height="120" style="opacity: 1">
          <?php endif; ?>
        </div>
        <p class="mb-0 fw-medium text-secondary">&copy; <?php echo e(date('Y')); ?> جميع الحقوق محفوظة</p>
      </div>
    </footer>
  </div>
  <?php if($navUser && $navUser->hasPermission('notifications.view')): ?>
    <div class="offcanvas offcanvas-end" tabindex="-1" id="notifOffcanvas" aria-labelledby="notifOffcanvasLabel">
      <div class="offcanvas-header">
        <h5 id="notifOffcanvasLabel" class="mb-0">الإشعارات</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body">
        <div class="d-flex gap-2 mb-2">
          <select id="notifSideFilter" class="form-select form-select-sm" style="width:auto">
            <option value="">الكل</option>
            <option value="success">نجاح</option>
            <option value="info">معلومة</option>
            <option value="warning">تحذير</option>
            <option value="danger">هام</option>
            <option value="secondary">عام</option>
          </select>
          <a href="<?php echo e(route('notifications.index')); ?>" class="btn btn-light btn-sm">عرض الكل</a>
        </div>
        <div id="notifSideList" class="d-flex flex-column gap-2"></div>
      </div>
    </div>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        var off = document.getElementById('notifOffcanvas');
        var list = document.getElementById('notifSideList');
        var filter = document.getElementById('notifSideFilter');
        var fKey = 'sidebar.notifications.filter';
        var render = function (items) {
          list.innerHTML = '';
          if (!items || !items.length) { list.innerHTML = '<div class="alert alert-secondary">لا توجد إشعارات</div>'; return; }
          var val = filter.value;
          items.forEach(function (n) {
            if (val && n.type !== val) return;
            var div = document.createElement('div');
            div.className = 'alert alert-' + n.type + ' d-flex justify-content-between align-items-center';
            var span = document.createElement('div'); span.textContent = n.text; div.appendChild(span);
            var a = document.createElement('a'); a.href = n.link; a.className = 'btn btn-outline-dark btn-sm'; a.textContent = 'فتح'; div.appendChild(a);
            list.appendChild(div);
          });
        };
        var load = function () {
          fetch('<?php echo e(route('notifications.index')); ?>?format=json').then(function (r) { return r.json() }).then(function (d) { render(d.items || []); }).catch(function () { render([]); });
        };
        off.addEventListener('shown.bs.offcanvas', load);
        filter.addEventListener('change', function () { localStorage.setItem(fKey, filter.value || ''); load(); });
        var saved = localStorage.getItem(fKey); if (saved !== null) filter.value = saved;
      });
    </script>
  <?php endif; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      flatpickr(".time-picker", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i",
        altInput: true,
        altFormat: "h:i K",
        time_24hr: false
      });
    });
  </script>
  <script>
    document.addEventListener('DOMContentLoaded', function () {
      var themeKey = 'ui.theme', themeBtn = document.getElementById('themeToggle');

      var applyTheme = function (v) {
        document.body.classList.toggle('theme-dark', v === 'dark');
        if (themeBtn) { themeBtn.innerHTML = v === 'dark' ? '<i class="bi bi-sun"></i>' : '<i class="bi bi-moon"></i>'; }
      };

      var curTheme = localStorage.getItem(themeKey) || 'light';
      applyTheme(curTheme);

      if (themeBtn) {
        themeBtn.addEventListener('click', function () {
          curTheme = (document.body.classList.contains('theme-dark') ? 'light' : 'dark');
          localStorage.setItem(themeKey, curTheme);
          applyTheme(curTheme);
        });
      }
    });
  </script>
</body>

</html><?php /**PATH F:\Enasn\resources\views/layouts/app.blade.php ENDPATH**/ ?>