<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-3">
    <h4>دليل الحسابات</h4>
    <a href="<?php echo e(route('accounts.create')); ?>" class="btn btn-primary">إضافة حساب</a>
</div>
<div class="card p-3">
    <table class="table table-bordered">
        <thead class="bg-transparent">
            <tr>
                <th>الكود</th>
                <th>الاسم</th>
                <th>النوع</th>
                <th>الحساب الرئيسي</th>
                <th>الوصف</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $allAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($account->code); ?></td>
                <td><?php echo e($account->name); ?></td>
                <td>
                    <?php switch($account->type):
                        case ('asset'): ?> أصول <?php break; ?>
                        <?php case ('liability'): ?> خصوم <?php break; ?>
                        <?php case ('equity'): ?> حقوق ملكية <?php break; ?>
                        <?php case ('revenue'): ?> إيرادات <?php break; ?>
                        <?php case ('expense'): ?> مصروفات <?php break; ?>
                        <?php default: ?> <?php echo e($account->type); ?>

                    <?php endswitch; ?>
                </td>
                <td><?php echo e(optional($account->parent)->name); ?></td>
                <td><?php echo e(Str::limit($account->description, 50)); ?></td>
                <td>
                    <a href="<?php echo e(route('accounts.show', $account)); ?>" class="btn btn-sm btn-outline-info">كشف حساب</a>
                    <a href="<?php echo e(route('accounts.edit', $account)); ?>" class="btn btn-sm btn-outline-primary">تعديل</a>
                    <form action="<?php echo e(route('accounts.destroy', $account)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد؟')">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-outline-danger">حذف</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo e($allAccounts->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/accounts/index.blade.php ENDPATH**/ ?>