<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-transparent border-bottom-0 pt-4 pb-0 px-4">
                    <h4 class="fw-bold text-dark mb-0">تسجيل حضور موظف</h4>
                    <p class="text-muted small mt-1">قم بتسجيل بيانات الحضور والانصراف للموظف.</p>
                </div>
                <div class="card-body p-4">
                    <form method="POST" action="<?php echo e(route('employee-attendance.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <label class="form-label fw-medium text-secondary">الموظف <span class="text-danger">*</span></label>
                                <select name="user_id" class="form-select form-select-lg fs-6" required>
                                    <option value="">اختر الموظف...</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-medium text-secondary">التاريخ <span class="text-danger">*</span></label>
                                <input type="date" name="date" class="form-control form-control-lg fs-6" value="<?php echo e(date('Y-m-d')); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-medium text-secondary">وقت الدخول</label>
                                <input type="time" name="check_in_at" class="form-control form-control-lg fs-6">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-medium text-secondary">وقت الخروج</label>
                                <input type="time" name="check_out_at" class="form-control form-control-lg fs-6">
                            </div>
                            <div class="col-12">
                                <label class="form-label fw-medium text-secondary">ملاحظات</label>
                                <textarea name="notes" class="form-control" rows="3" placeholder="أي ملاحظات إضافية حول الحضور..."></textarea>
                            </div>
                            
                            <div class="col-12 mt-4">
                                <h5 class="fw-bold text-dark border-bottom pb-2 mb-3">تقييم الأداء</h5>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="form-label fw-medium text-secondary d-block">التقييم (من 5)</label>
                                        <div class="btn-group" role="group" aria-label="Rating">
                                            <?php for($i=1; $i<=5; $i++): ?>
                                                <input type="radio" class="btn-check" name="rating" id="rating<?php echo e($i); ?>" value="<?php echo e($i); ?>" autocomplete="off">
                                                <label class="btn btn-outline-warning" for="rating<?php echo e($i); ?>"><?php echo e($i); ?> <i class="bi bi-star-fill"></i></label>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-medium text-secondary">ملاحظات التقييم</label>
                                        <textarea name="evaluation_notes" class="form-control" rows="2" placeholder="أضف ملاحظات حول أداء الموظف في هذا اليوم..."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mt-5">
                            <a href="<?php echo e(route('employee-attendance.index')); ?>" class="btn btn-light btn-lg px-4 me-2 rounded-pill text-secondary">إلغاء</a>
                            <button type="submit" class="btn btn-primary btn-lg px-5 rounded-pill shadow-sm">حفظ السجل</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/employee_attendance/create.blade.php ENDPATH**/ ?>